/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.google.common.base.MoreObjects;
import java.util.Optional;

public class SortItem
extends Node {
    private final Expression sortKey;
    private final Ordering ordering;
    private final NullOrdering nullOrdering;

    public SortItem(Expression sortKey, Ordering ordering, NullOrdering nullOrdering) {
        this(Optional.empty(), sortKey, ordering, nullOrdering);
    }

    public SortItem(NodeLocation location, Expression sortKey, Ordering ordering, NullOrdering nullOrdering) {
        this(Optional.of(location), sortKey, ordering, nullOrdering);
    }

    private SortItem(Optional<NodeLocation> location, Expression sortKey, Ordering ordering, NullOrdering nullOrdering) {
        super(location);
        this.ordering = ordering;
        this.sortKey = sortKey;
        this.nullOrdering = nullOrdering;
    }

    public Expression getSortKey() {
        return this.sortKey;
    }

    public Ordering getOrdering() {
        return this.ordering;
    }

    public NullOrdering getNullOrdering() {
        return this.nullOrdering;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSortItem(this, context);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sortKey", (Object)this.sortKey).add("ordering", (Object)this.ordering).add("nullOrdering", (Object)this.nullOrdering).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SortItem sortItem = (SortItem)o;
        if (this.nullOrdering != sortItem.nullOrdering) {
            return false;
        }
        if (this.ordering != sortItem.ordering) {
            return false;
        }
        return this.sortKey.equals(sortItem.sortKey);
    }

    @Override
    public int hashCode() {
        int result = this.sortKey.hashCode();
        result = 31 * result + (this.ordering != null ? this.ordering.hashCode() : 0);
        result = 31 * result + (this.nullOrdering != null ? this.nullOrdering.hashCode() : 0);
        return result;
    }

    public static enum NullOrdering {
        FIRST,
        LAST,
        UNDEFINED;

    }

    public static enum Ordering {
        ASCENDING,
        DESCENDING;

    }
}

