/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.parser;

import com.facebook.presto.sql.parser.IdentifierSymbol;
import com.google.common.collect.Iterables;
import java.util.EnumSet;
import java.util.Objects;

public class SqlParserOptions {
    private EnumSet<IdentifierSymbol> allowedIdentifierSymbols = EnumSet.noneOf(IdentifierSymbol.class);

    public SqlParserOptions allowIdentifierSymbol(Iterable<IdentifierSymbol> identifierSymbols) {
        Iterables.addAll(this.allowedIdentifierSymbols, identifierSymbols);
        return this;
    }

    public EnumSet<IdentifierSymbol> getAllowedIdentifierSymbols() {
        return EnumSet.copyOf(this.allowedIdentifierSymbols);
    }

    public SqlParserOptions allowIdentifierSymbol(IdentifierSymbol ... identifierSymbols) {
        for (IdentifierSymbol identifierSymbol : identifierSymbols) {
            this.allowedIdentifierSymbols.add(Objects.requireNonNull(identifierSymbol, "identifierSymbol is null"));
        }
        return this;
    }
}

