/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Literal;
import java.util.Objects;

public class DoubleLiteral
extends Literal {
    private final double value;

    public DoubleLiteral(String value) {
        Objects.requireNonNull(value, "value is null");
        this.value = Double.parseDouble(value);
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDoubleLiteral(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoubleLiteral that = (DoubleLiteral)o;
        return Double.compare(that.value, this.value) == 0;
    }

    @Override
    public int hashCode() {
        long temp = this.value != 0.0 ? Double.doubleToLongBits(this.value) : 0L;
        return (int)(temp ^ temp >>> 32);
    }
}

