/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql;

import com.facebook.presto.sql.ExpressionFormatter;
import com.facebook.presto.sql.tree.AddColumn;
import com.facebook.presto.sql.tree.AliasedRelation;
import com.facebook.presto.sql.tree.AllColumns;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.CreateTable;
import com.facebook.presto.sql.tree.CreateTableAsSelect;
import com.facebook.presto.sql.tree.CreateView;
import com.facebook.presto.sql.tree.Delete;
import com.facebook.presto.sql.tree.DropTable;
import com.facebook.presto.sql.tree.DropView;
import com.facebook.presto.sql.tree.Except;
import com.facebook.presto.sql.tree.Explain;
import com.facebook.presto.sql.tree.ExplainFormat;
import com.facebook.presto.sql.tree.ExplainOption;
import com.facebook.presto.sql.tree.ExplainType;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Insert;
import com.facebook.presto.sql.tree.Intersect;
import com.facebook.presto.sql.tree.Join;
import com.facebook.presto.sql.tree.JoinCriteria;
import com.facebook.presto.sql.tree.JoinOn;
import com.facebook.presto.sql.tree.JoinUsing;
import com.facebook.presto.sql.tree.NaturalJoin;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.RenameColumn;
import com.facebook.presto.sql.tree.RenameTable;
import com.facebook.presto.sql.tree.ResetSession;
import com.facebook.presto.sql.tree.SampledRelation;
import com.facebook.presto.sql.tree.Select;
import com.facebook.presto.sql.tree.SelectItem;
import com.facebook.presto.sql.tree.SetSession;
import com.facebook.presto.sql.tree.ShowCatalogs;
import com.facebook.presto.sql.tree.ShowColumns;
import com.facebook.presto.sql.tree.ShowFunctions;
import com.facebook.presto.sql.tree.ShowPartitions;
import com.facebook.presto.sql.tree.ShowSchemas;
import com.facebook.presto.sql.tree.ShowSession;
import com.facebook.presto.sql.tree.ShowTables;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.sql.tree.Table;
import com.facebook.presto.sql.tree.TableSubquery;
import com.facebook.presto.sql.tree.Union;
import com.facebook.presto.sql.tree.Unnest;
import com.facebook.presto.sql.tree.Values;
import com.facebook.presto.sql.tree.With;
import com.facebook.presto.sql.tree.WithQuery;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class SqlFormatter {
    private static final String INDENT = "   ";

    private SqlFormatter() {
    }

    public static String formatSql(Node root) {
        StringBuilder builder = new StringBuilder();
        new Formatter(builder, true).process(root, 0);
        return builder.toString();
    }

    public static String formatSql(Node root, boolean unmangleNames) {
        StringBuilder builder = new StringBuilder();
        new Formatter(builder, unmangleNames).process(root, 0);
        return builder.toString();
    }

    private static void appendAliasColumns(StringBuilder builder, List<String> columns) {
        if (columns != null && !columns.isEmpty()) {
            builder.append(" (");
            Joiner.on((String)", ").appendTo(builder, columns);
            builder.append(')');
        }
    }

    private static class Formatter
    extends AstVisitor<Void, Integer> {
        private final StringBuilder builder;
        private final boolean unmangledNames;

        public Formatter(StringBuilder builder, boolean unmangleNames) {
            this.builder = builder;
            this.unmangledNames = unmangleNames;
        }

        @Override
        protected Void visitNode(Node node, Integer indent) {
            throw new UnsupportedOperationException("not yet implemented: " + node);
        }

        @Override
        protected Void visitExpression(Expression node, Integer indent) {
            Preconditions.checkArgument((indent == 0 ? 1 : 0) != 0, (Object)"visitExpression should only be called at root");
            this.builder.append(ExpressionFormatter.formatExpression(node, this.unmangledNames));
            return null;
        }

        @Override
        protected Void visitUnnest(Unnest node, Integer indent) {
            this.builder.append(node.toString());
            return null;
        }

        @Override
        protected Void visitQuery(Query node, Integer indent) {
            if (node.getWith().isPresent()) {
                With with = node.getWith().get();
                this.append(indent, "WITH");
                if (with.isRecursive()) {
                    this.builder.append(" RECURSIVE");
                }
                this.builder.append("\n  ");
                Iterator<WithQuery> queries = with.getQueries().iterator();
                while (queries.hasNext()) {
                    WithQuery query = queries.next();
                    this.append(indent, query.getName());
                    SqlFormatter.appendAliasColumns(this.builder, query.getColumnNames());
                    this.builder.append(" AS ");
                    this.process(new TableSubquery(query.getQuery()), indent);
                    this.builder.append('\n');
                    if (!queries.hasNext()) continue;
                    this.builder.append(", ");
                }
            }
            this.processRelation(node.getQueryBody(), indent);
            if (!node.getOrderBy().isEmpty()) {
                this.append(indent, "ORDER BY " + ExpressionFormatter.formatSortItems(node.getOrderBy())).append('\n');
            }
            if (node.getLimit().isPresent()) {
                this.append(indent, "LIMIT " + node.getLimit().get()).append('\n');
            }
            if (node.getApproximate().isPresent()) {
                String confidence = node.getApproximate().get().getConfidence();
                this.append(indent, "APPROXIMATE AT " + confidence + " CONFIDENCE").append('\n');
            }
            return null;
        }

        @Override
        protected Void visitQuerySpecification(QuerySpecification node, Integer indent) {
            this.process(node.getSelect(), indent);
            if (node.getFrom().isPresent()) {
                this.append(indent, "FROM");
                this.builder.append('\n');
                this.append(indent, "  ");
                this.process(node.getFrom().get(), indent);
            }
            this.builder.append('\n');
            if (node.getWhere().isPresent()) {
                this.append(indent, "WHERE " + ExpressionFormatter.formatExpression(node.getWhere().get())).append('\n');
            }
            if (!node.getGroupBy().isEmpty()) {
                this.append(indent, "GROUP BY " + Joiner.on((String)", ").join(Iterables.transform(node.getGroupBy(), ExpressionFormatter::formatExpression))).append('\n');
            }
            if (node.getHaving().isPresent()) {
                this.append(indent, "HAVING " + ExpressionFormatter.formatExpression(node.getHaving().get())).append('\n');
            }
            if (!node.getOrderBy().isEmpty()) {
                this.append(indent, "ORDER BY " + ExpressionFormatter.formatSortItems(node.getOrderBy())).append('\n');
            }
            if (node.getLimit().isPresent()) {
                this.append(indent, "LIMIT " + node.getLimit().get()).append('\n');
            }
            return null;
        }

        @Override
        protected Void visitSelect(Select node, Integer indent) {
            this.append(indent, "SELECT");
            if (node.isDistinct()) {
                this.builder.append(" DISTINCT");
            }
            if (node.getSelectItems().size() > 1) {
                boolean first = true;
                for (SelectItem item : node.getSelectItems()) {
                    this.builder.append("\n").append(Formatter.indentString(indent)).append(first ? "  " : ", ");
                    this.process(item, indent);
                    first = false;
                }
            } else {
                this.builder.append(' ');
                this.process((Node)Iterables.getOnlyElement(node.getSelectItems()), indent);
            }
            this.builder.append('\n');
            return null;
        }

        @Override
        protected Void visitSingleColumn(SingleColumn node, Integer indent) {
            this.builder.append(ExpressionFormatter.formatExpression(node.getExpression()));
            if (node.getAlias().isPresent()) {
                this.builder.append(' ').append('\"').append(node.getAlias().get()).append('\"');
            }
            return null;
        }

        @Override
        protected Void visitAllColumns(AllColumns node, Integer context) {
            this.builder.append(node.toString());
            return null;
        }

        @Override
        protected Void visitTable(Table node, Integer indent) {
            this.builder.append(node.getName().toString());
            return null;
        }

        @Override
        protected Void visitJoin(Join node, Integer indent) {
            JoinCriteria criteria = node.getCriteria().orElse(null);
            String type = node.getType().toString();
            if (criteria instanceof NaturalJoin) {
                type = "NATURAL " + type;
            }
            if (node.getType() != Join.Type.IMPLICIT) {
                this.builder.append('(');
            }
            this.process(node.getLeft(), indent);
            this.builder.append('\n');
            if (node.getType() == Join.Type.IMPLICIT) {
                this.append(indent, ", ");
            } else {
                this.append(indent, type).append(" JOIN ");
            }
            this.process(node.getRight(), indent);
            if (node.getType() != Join.Type.CROSS && node.getType() != Join.Type.IMPLICIT) {
                if (criteria instanceof JoinUsing) {
                    JoinUsing using = (JoinUsing)criteria;
                    this.builder.append(" USING (").append(Joiner.on((String)", ").join(using.getColumns())).append(")");
                } else if (criteria instanceof JoinOn) {
                    JoinOn on = (JoinOn)criteria;
                    this.builder.append(" ON (").append(ExpressionFormatter.formatExpression(on.getExpression())).append(")");
                } else if (!(criteria instanceof NaturalJoin)) {
                    throw new UnsupportedOperationException("unknown join criteria: " + criteria);
                }
            }
            if (node.getType() != Join.Type.IMPLICIT) {
                this.builder.append(")");
            }
            return null;
        }

        @Override
        protected Void visitAliasedRelation(AliasedRelation node, Integer indent) {
            this.process(node.getRelation(), indent);
            this.builder.append(' ').append(node.getAlias());
            SqlFormatter.appendAliasColumns(this.builder, node.getColumnNames());
            return null;
        }

        @Override
        protected Void visitSampledRelation(SampledRelation node, Integer indent) {
            this.process(node.getRelation(), indent);
            this.builder.append(" TABLESAMPLE ").append((Object)node.getType()).append(" (").append(node.getSamplePercentage()).append(')');
            if (node.getColumnsToStratifyOn().isPresent()) {
                this.builder.append(" STRATIFY ON ").append(" (").append(Joiner.on((String)",").join((Iterable)node.getColumnsToStratifyOn().get()));
                this.builder.append(')');
            }
            return null;
        }

        @Override
        protected Void visitValues(Values node, Integer indent) {
            this.builder.append(" VALUES ");
            boolean first = true;
            for (Expression row : node.getRows()) {
                this.builder.append("\n").append(Formatter.indentString(indent)).append(first ? "  " : ", ");
                this.builder.append(ExpressionFormatter.formatExpression(row));
                first = false;
            }
            this.builder.append('\n');
            return null;
        }

        @Override
        protected Void visitTableSubquery(TableSubquery node, Integer indent) {
            this.builder.append('(').append('\n');
            this.process(node.getQuery(), indent + 1);
            this.append(indent, ") ");
            return null;
        }

        @Override
        protected Void visitUnion(Union node, Integer indent) {
            Iterator<Relation> relations = node.getRelations().iterator();
            while (relations.hasNext()) {
                this.processRelation(relations.next(), indent);
                if (!relations.hasNext()) continue;
                this.builder.append("UNION ");
                if (node.isDistinct()) continue;
                this.builder.append("ALL ");
            }
            return null;
        }

        @Override
        protected Void visitExcept(Except node, Integer indent) {
            this.processRelation(node.getLeft(), indent);
            this.builder.append("EXCEPT ");
            if (!node.isDistinct()) {
                this.builder.append("ALL ");
            }
            this.processRelation(node.getRight(), indent);
            return null;
        }

        @Override
        protected Void visitIntersect(Intersect node, Integer indent) {
            Iterator<Relation> relations = node.getRelations().iterator();
            while (relations.hasNext()) {
                this.processRelation(relations.next(), indent);
                if (!relations.hasNext()) continue;
                this.builder.append("INTERSECT ");
                if (node.isDistinct()) continue;
                this.builder.append("ALL ");
            }
            return null;
        }

        @Override
        protected Void visitCreateView(CreateView node, Integer indent) {
            this.builder.append("CREATE ");
            if (node.isReplace()) {
                this.builder.append("OR REPLACE ");
            }
            this.builder.append("VIEW ").append(node.getName()).append(" AS\n");
            this.process(node.getQuery(), indent);
            return null;
        }

        @Override
        protected Void visitDropView(DropView node, Integer context) {
            this.builder.append("DROP VIEW ");
            if (node.isExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(node.getName());
            return null;
        }

        @Override
        protected Void visitExplain(Explain node, Integer indent) {
            this.builder.append("EXPLAIN ");
            ArrayList<String> options = new ArrayList<String>();
            for (ExplainOption option : node.getOptions()) {
                if (option instanceof ExplainType) {
                    options.add("TYPE " + (Object)((Object)((ExplainType)option).getType()));
                    continue;
                }
                if (option instanceof ExplainFormat) {
                    options.add("FORMAT " + (Object)((Object)((ExplainFormat)option).getType()));
                    continue;
                }
                throw new UnsupportedOperationException("unhandled explain option: " + option);
            }
            if (!options.isEmpty()) {
                this.builder.append("(");
                Joiner.on((String)", ").appendTo(this.builder, options);
                this.builder.append(")");
            }
            this.builder.append("\n");
            this.process(node.getStatement(), indent);
            return null;
        }

        @Override
        protected Void visitShowCatalogs(ShowCatalogs node, Integer context) {
            this.builder.append("SHOW CATALOGS");
            return null;
        }

        @Override
        protected Void visitShowSchemas(ShowSchemas node, Integer context) {
            this.builder.append("SHOW SCHEMAS");
            if (node.getCatalog().isPresent()) {
                this.builder.append(" FROM ").append(node.getCatalog().get());
            }
            return null;
        }

        @Override
        protected Void visitShowTables(ShowTables node, Integer context) {
            this.builder.append("SHOW TABLES");
            node.getSchema().ifPresent(value -> this.builder.append(" FROM ").append(value));
            node.getLikePattern().ifPresent(value -> this.builder.append(" LIKE ").append(ExpressionFormatter.formatStringLiteral(value)));
            return null;
        }

        @Override
        protected Void visitShowColumns(ShowColumns node, Integer context) {
            this.builder.append("SHOW COLUMNS FROM ").append(node.getTable());
            return null;
        }

        @Override
        protected Void visitShowPartitions(ShowPartitions node, Integer context) {
            this.builder.append("SHOW PARTITIONS FROM ").append(node.getTable());
            if (node.getWhere().isPresent()) {
                this.builder.append(" WHERE ").append(ExpressionFormatter.formatExpression(node.getWhere().get()));
            }
            if (!node.getOrderBy().isEmpty()) {
                this.builder.append(" ORDER BY ").append(ExpressionFormatter.formatSortItems(node.getOrderBy()));
            }
            if (node.getLimit().isPresent()) {
                this.builder.append(" LIMIT ").append(node.getLimit().get());
            }
            return null;
        }

        @Override
        protected Void visitShowFunctions(ShowFunctions node, Integer context) {
            this.builder.append("SHOW FUNCTIONS");
            return null;
        }

        @Override
        protected Void visitShowSession(ShowSession node, Integer context) {
            this.builder.append("SHOW SESSION");
            return null;
        }

        @Override
        protected Void visitDelete(Delete node, Integer context) {
            this.builder.append("DELETE FROM ").append(node.getTable().getName());
            if (node.getWhere().isPresent()) {
                this.builder.append(" WHERE ").append(ExpressionFormatter.formatExpression(node.getWhere().get()));
            }
            return null;
        }

        @Override
        protected Void visitCreateTableAsSelect(CreateTableAsSelect node, Integer indent) {
            this.builder.append("CREATE TABLE ").append(node.getName());
            if (!node.getProperties().isEmpty()) {
                this.builder.append(" WITH (");
                Joiner.on((String)", ").appendTo(this.builder, Iterables.transform(node.getProperties().entrySet(), entry -> (String)entry.getKey() + " = " + ExpressionFormatter.formatExpression((Expression)entry.getValue())));
                this.builder.append(")");
            }
            this.builder.append(" AS ");
            this.process(node.getQuery(), indent);
            if (!node.isWithData()) {
                this.builder.append(" WITH NO DATA");
            }
            return null;
        }

        @Override
        protected Void visitCreateTable(CreateTable node, Integer indent) {
            this.builder.append("CREATE TABLE ");
            if (node.isNotExists()) {
                this.builder.append("IF NOT EXISTS ");
            }
            this.builder.append(node.getName()).append(" (");
            Joiner.on((String)", ").appendTo(this.builder, Iterables.transform(node.getElements(), element -> element.getName() + " " + element.getType()));
            this.builder.append(")");
            if (!node.getProperties().isEmpty()) {
                this.builder.append(" WITH (");
                Joiner.on((String)", ").appendTo(this.builder, Iterables.transform(node.getProperties().entrySet(), entry -> (String)entry.getKey() + " = " + ExpressionFormatter.formatExpression((Expression)entry.getValue())));
                this.builder.append(")");
            }
            return null;
        }

        @Override
        protected Void visitDropTable(DropTable node, Integer context) {
            this.builder.append("DROP TABLE ");
            if (node.isExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(node.getTableName());
            return null;
        }

        @Override
        protected Void visitRenameTable(RenameTable node, Integer context) {
            this.builder.append("ALTER TABLE ").append(node.getSource()).append(" RENAME TO ").append(node.getTarget());
            return null;
        }

        @Override
        protected Void visitRenameColumn(RenameColumn node, Integer context) {
            this.builder.append("ALTER TABLE ").append(node.getTable()).append(" RENAME COLUMN ").append(node.getSource()).append(" TO ").append(node.getTarget());
            return null;
        }

        @Override
        protected Void visitAddColumn(AddColumn node, Integer indent) {
            this.builder.append("ALTER TABLE ").append(node.getName()).append(" ADD COLUMN ").append(node.getColumn().getName()).append(" ").append(node.getColumn().getType());
            return null;
        }

        @Override
        protected Void visitInsert(Insert node, Integer indent) {
            this.builder.append("INSERT INTO ").append(node.getTarget()).append(" ");
            this.process(node.getQuery(), indent);
            return null;
        }

        @Override
        public Void visitSetSession(SetSession node, Integer context) {
            this.builder.append("SET SESSION ").append(node.getName()).append(" = ").append(ExpressionFormatter.formatExpression(node.getValue()));
            return null;
        }

        @Override
        public Void visitResetSession(ResetSession node, Integer context) {
            this.builder.append("RESET SESSION ").append(node.getName());
            return null;
        }

        private void processRelation(Relation relation, Integer indent) {
            if (relation instanceof Table) {
                this.builder.append("TABLE ").append(((Table)relation).getName()).append('\n');
            } else {
                this.process(relation, indent);
            }
        }

        private StringBuilder append(int indent, String value) {
            return this.builder.append(Formatter.indentString(indent)).append(value);
        }

        private static String indentString(int indent) {
            return Strings.repeat((String)SqlFormatter.INDENT, (int)indent);
        }
    }
}

