/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.MoreObjects;
import java.util.Objects;

public final class Insert
extends Statement {
    private final QualifiedName target;
    private final Query query;

    public Insert(QualifiedName target, Query query) {
        this.target = Objects.requireNonNull(target, "target is null");
        this.query = Objects.requireNonNull(query, "query is null");
    }

    public QualifiedName getTarget() {
        return this.target;
    }

    public Query getQuery() {
        return this.query;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitInsert(this, context);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.target, this.query);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Insert o = (Insert)obj;
        return Objects.equals(this.target, o.target) && Objects.equals(this.query, o.query);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("target", (Object)this.target).add("query", (Object)this.query).toString();
    }
}

