/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class CreateTableAsSelect
extends Statement {
    private final QualifiedName name;
    private final Query query;

    public CreateTableAsSelect(QualifiedName name, Query query) {
        this.name = (QualifiedName)Preconditions.checkNotNull((Object)name, (Object)"name is null");
        this.query = (Query)Preconditions.checkNotNull((Object)query, (Object)"query is null");
    }

    public QualifiedName getName() {
        return this.name;
    }

    public Query getQuery() {
        return this.query;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCreateTableAsSelect(this, context);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.query);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CreateTableAsSelect o = (CreateTableAsSelect)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.query, o.query);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("query", (Object)this.query).toString();
    }
}

