/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class ArrayConstructor
extends Expression {
    public static final String ARRAY_CONSTRUCTOR = "ARRAY_CONSTRUCTOR";
    private final List<Expression> values;

    public ArrayConstructor(List<Expression> values) {
        Preconditions.checkNotNull(values, (Object)"values is null");
        this.values = ImmutableList.copyOf(values);
    }

    public List<Expression> getValues() {
        return this.values;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitArrayConstructor(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrayConstructor that = (ArrayConstructor)o;
        return this.values.equals(that.values);
    }

    @Override
    public int hashCode() {
        return this.values.hashCode();
    }
}

