/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.sql.tree.TableElement;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class CreateTable
extends Statement {
    private final QualifiedName name;
    private final List<TableElement> elements;
    private final boolean notExists;

    public CreateTable(QualifiedName name, List<TableElement> elements, boolean notExists) {
        this.name = (QualifiedName)Preconditions.checkNotNull((Object)name, (Object)"table is null");
        this.elements = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(elements, (Object)"elements is null")));
        this.notExists = notExists;
    }

    public QualifiedName getName() {
        return this.name;
    }

    public List<TableElement> getElements() {
        return this.elements;
    }

    public boolean isNotExists() {
        return this.notExists;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCreateTable(this, context);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.elements, this.notExists);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CreateTable o = (CreateTable)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.elements, o.elements) && Objects.equals(this.notExists, o.notExists);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("elements", this.elements).add("notExists", this.notExists).toString();
    }
}

