/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.block;

import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.block.BlockReader;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.stream.BooleanStream;
import com.facebook.presto.orc.stream.ByteStream;
import com.facebook.presto.orc.stream.StreamSources;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;

public class ByteBlockReader
implements BlockReader {
    private final StreamDescriptor streamDescriptor;
    @Nullable
    private BooleanStream presentStream;
    @Nullable
    private ByteStream dataStream;

    public ByteBlockReader(StreamDescriptor streamDescriptor) {
        this.streamDescriptor = (StreamDescriptor)Preconditions.checkNotNull((Object)streamDescriptor, (Object)"stream is null");
    }

    @Override
    public boolean readNextValueInto(BlockBuilder builder, boolean skipNull) throws IOException {
        if (this.presentStream != null && !this.presentStream.nextBit()) {
            if (!skipNull) {
                builder.appendNull();
                return true;
            }
            return false;
        }
        if (this.dataStream == null) {
            throw new OrcCorruptionException("Value is not null but data stream is not present");
        }
        BigintType.BIGINT.writeLong(builder, (long)this.dataStream.next());
        return true;
    }

    @Override
    public void skip(int skipSize) throws IOException {
        if (this.presentStream != null) {
            skipSize = this.presentStream.countBitsSet(skipSize);
        }
        if (skipSize == 0) {
            return;
        }
        if (this.dataStream == null) {
            throw new OrcCorruptionException("Value is not null but data stream is not present");
        }
        this.dataStream.skip(skipSize);
    }

    @Override
    public void openStripe(StreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) throws IOException {
        this.presentStream = null;
        this.dataStream = null;
    }

    @Override
    public void openRowGroup(StreamSources dataStreamSources) throws IOException {
        this.presentStream = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanStream.class).openStream();
        this.dataStream = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.DATA, ByteStream.class).openStream();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }
}

