/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.ObjectVector;
import com.facebook.presto.orc.Vector;
import com.google.common.annotations.VisibleForTesting;

public class DoubleVector
implements Vector {
    public final boolean[] isNull;
    public final double[] vector;

    public DoubleVector(int length) {
        if (length > 1024) {
            throw new IllegalArgumentException("length greater than max vector length");
        }
        this.vector = new double[length];
        this.isNull = new boolean[length];
    }

    @Override
    @VisibleForTesting
    public ObjectVector toObjectVector(int size) {
        ObjectVector objectVector = new ObjectVector(this.vector.length);
        for (int i = 0; i < size; ++i) {
            if (this.isNull[i]) continue;
            objectVector.vector[i] = this.vector[i];
        }
        return objectVector;
    }
}

