/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.orc.SliceVector;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.json.JsonReader;
import com.facebook.presto.orc.json.JsonReaders;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.reader.OrcReaderUtils;
import com.facebook.presto.orc.reader.StreamReader;
import com.facebook.presto.orc.stream.BooleanStream;
import com.facebook.presto.orc.stream.MissingStreamSource;
import com.facebook.presto.orc.stream.StreamSource;
import com.facebook.presto.orc.stream.StreamSources;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.slice.DynamicSliceOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.DateTimeZone;

public class JsonStreamReader
implements StreamReader {
    private final StreamDescriptor streamDescriptor;
    private final JsonReader jsonReader;
    private boolean stripeOpen;
    private boolean rowGroupOpen;
    @Nonnull
    private StreamSource<BooleanStream> presentStreamSource = MissingStreamSource.missingStreamSource(BooleanStream.class);
    @Nullable
    private BooleanStream presentStream;
    private final boolean[] isNullVector = new boolean[1024];
    private int readOffset;
    private int nextBatchSize;
    @Nullable
    private StreamSources dictionaryStreamSources;
    @Nullable
    private StreamSources dataStreamSources;
    private List<ColumnEncoding> encoding;

    public JsonStreamReader(StreamDescriptor streamDescriptor, DateTimeZone hiveStorageTimeZone) {
        this.streamDescriptor = (StreamDescriptor)Preconditions.checkNotNull((Object)streamDescriptor, (Object)"stream is null");
        this.jsonReader = JsonReaders.createJsonReader(streamDescriptor, false, hiveStorageTimeZone);
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public void readBatch(Object vector) throws IOException {
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            this.jsonReader.skip(this.readOffset);
        }
        SliceVector sliceVector = OrcReaderUtils.castOrcVector(vector, SliceVector.class);
        if (this.presentStream != null) {
            this.presentStream.getUnsetBits(this.nextBatchSize, this.isNullVector);
        }
        DynamicSliceOutput out = new DynamicSliceOutput(1024);
        for (int i = 0; i < this.nextBatchSize; ++i) {
            if (!this.isNullVector[i]) {
                out.reset();
                try (JsonGenerator generator = new JsonFactory().createGenerator((OutputStream)out);){
                    this.jsonReader.readNextValueInto(generator);
                }
                sliceVector.vector[i] = out.copySlice();
                continue;
            }
            sliceVector.vector[i] = null;
        }
        this.readOffset = 0;
        this.nextBatchSize = 0;
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        if (!this.stripeOpen) {
            this.jsonReader.openStripe(this.dictionaryStreamSources, this.encoding);
        }
        this.jsonReader.openRowGroup(this.dataStreamSources);
        this.rowGroupOpen = true;
    }

    @Override
    public void startStripe(StreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) throws IOException {
        this.dictionaryStreamSources = dictionaryStreamSources;
        this.dataStreamSources = null;
        this.encoding = encoding;
        this.presentStreamSource = MissingStreamSource.missingStreamSource(BooleanStream.class);
        this.stripeOpen = false;
        this.rowGroupOpen = false;
        this.readOffset = 0;
        this.nextBatchSize = 0;
        Arrays.fill(this.isNullVector, false);
        this.presentStream = null;
    }

    @Override
    public void startRowGroup(StreamSources dataStreamSources) throws IOException {
        this.dataStreamSources = dataStreamSources;
        this.presentStreamSource = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanStream.class);
        this.rowGroupOpen = false;
        this.readOffset = 0;
        this.nextBatchSize = 0;
        Arrays.fill(this.isNullVector, false);
        this.presentStream = null;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }
}

