/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.json;

import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.json.JsonMapKeyReader;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.reader.TimestampStreamReader;
import com.facebook.presto.orc.stream.BooleanStream;
import com.facebook.presto.orc.stream.LongStream;
import com.facebook.presto.orc.stream.StreamSources;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class TimestampJsonReader
implements JsonMapKeyReader {
    private final StreamDescriptor streamDescriptor;
    private final long baseTimestampInSeconds;
    @Nullable
    private BooleanStream presentStream;
    @Nullable
    private LongStream secondsStream;
    @Nullable
    private LongStream nanosStream;

    public TimestampJsonReader(StreamDescriptor streamDescriptor, DateTimeZone hiveStorageTimeZone) {
        this.streamDescriptor = (StreamDescriptor)Preconditions.checkNotNull((Object)streamDescriptor, (Object)"stream is null");
        this.baseTimestampInSeconds = new DateTime(2015, 1, 1, 0, 0, (DateTimeZone)Preconditions.checkNotNull((Object)hiveStorageTimeZone, (Object)"hiveStorageTimeZone is null")).getMillis() / 1000L;
    }

    @Override
    public void readNextValueInto(JsonGenerator generator) throws IOException {
        if (this.presentStream != null && !this.presentStream.nextBit()) {
            generator.writeNull();
            return;
        }
        if (this.secondsStream == null) {
            throw new OrcCorruptionException("Value is not null but seconds stream is not present");
        }
        if (this.nanosStream == null) {
            throw new OrcCorruptionException("Value is not null but nanos stream is not present");
        }
        long timestamp = TimestampStreamReader.decodeTimestamp(this.secondsStream.next(), this.nanosStream.next(), this.baseTimestampInSeconds);
        generator.writeNumber(timestamp);
    }

    @Override
    public String nextValueAsMapKey() throws IOException {
        if (this.presentStream != null && !this.presentStream.nextBit()) {
            return null;
        }
        if (this.secondsStream == null) {
            throw new OrcCorruptionException("Value is not null but seconds stream is not present");
        }
        if (this.nanosStream == null) {
            throw new OrcCorruptionException("Value is not null but nanos stream is not present");
        }
        long timestamp = TimestampStreamReader.decodeTimestamp(this.secondsStream.next(), this.nanosStream.next(), this.baseTimestampInSeconds);
        return String.valueOf(timestamp);
    }

    @Override
    public void skip(int skipSize) throws IOException {
        if (this.presentStream != null) {
            skipSize = this.presentStream.countBitsSet(skipSize);
        }
        if (skipSize == 0) {
            return;
        }
        if (this.secondsStream == null) {
            throw new OrcCorruptionException("Value is not null but seconds stream is not present");
        }
        if (this.nanosStream == null) {
            throw new OrcCorruptionException("Value is not null but nanos stream is not present");
        }
        this.secondsStream.skip(skipSize);
        this.nanosStream.skip(skipSize);
    }

    @Override
    public void openStripe(StreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) throws IOException {
        this.presentStream = null;
        this.secondsStream = null;
        this.nanosStream = null;
    }

    @Override
    public void openRowGroup(StreamSources dataStreamSources) throws IOException {
        this.presentStream = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanStream.class).openStream();
        this.secondsStream = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.DATA, LongStream.class).openStream();
        this.nanosStream = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.SECONDARY, LongStream.class).openStream();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }
}

