/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.json;

import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.json.JsonReader;
import com.facebook.presto.orc.json.JsonReaders;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.stream.BooleanStream;
import com.facebook.presto.orc.stream.StreamSources;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.joda.time.DateTimeZone;

public class StructJsonReader
implements JsonReader {
    private final StreamDescriptor streamDescriptor;
    private final boolean checkForNulls;
    private final JsonReader[] structFields;
    @Nullable
    private BooleanStream presentStream;

    public StructJsonReader(StreamDescriptor streamDescriptor, boolean checkForNulls, DateTimeZone hiveStorageTimeZone) {
        this.streamDescriptor = (StreamDescriptor)Preconditions.checkNotNull((Object)streamDescriptor, (Object)"stream is null");
        this.checkForNulls = checkForNulls;
        List<StreamDescriptor> nestedStreams = streamDescriptor.getNestedStreams();
        this.structFields = new JsonReader[nestedStreams.size()];
        for (int i = 0; i < nestedStreams.size(); ++i) {
            StreamDescriptor nestedStream = nestedStreams.get(i);
            this.structFields[i] = JsonReaders.createJsonReader(nestedStream, true, hiveStorageTimeZone);
        }
    }

    @Override
    public void readNextValueInto(JsonGenerator generator) throws IOException {
        if (this.presentStream != null && !this.presentStream.nextBit()) {
            generator.writeNull();
            return;
        }
        generator.writeStartArray();
        for (JsonReader structField : this.structFields) {
            structField.readNextValueInto(generator);
        }
        generator.writeEndArray();
    }

    @Override
    public void skip(int skipSize) throws IOException {
        if (this.presentStream != null) {
            skipSize = this.presentStream.countBitsSet(skipSize);
        }
        for (JsonReader structField : this.structFields) {
            structField.skip(skipSize);
        }
    }

    @Override
    public void openStripe(StreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) throws IOException {
        this.presentStream = null;
        for (JsonReader structField : this.structFields) {
            structField.openStripe(dictionaryStreamSources, encoding);
        }
    }

    @Override
    public void openRowGroup(StreamSources dataStreamSources) throws IOException {
        if (this.checkForNulls) {
            this.presentStream = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanStream.class).openStream();
        }
        for (JsonReader structField : this.structFields) {
            structField.openRowGroup(dataStreamSources);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }
}

