/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.json;

import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.json.JsonReader;
import com.facebook.presto.orc.json.JsonReaders;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.stream.BooleanStream;
import com.facebook.presto.orc.stream.LongStream;
import com.facebook.presto.orc.stream.StreamSources;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.joda.time.DateTimeZone;

public class ListJsonReader
implements JsonReader {
    private final StreamDescriptor streamDescriptor;
    private final boolean checkForNulls;
    private final JsonReader elementReader;
    @Nullable
    private BooleanStream presentStream;
    @Nullable
    private LongStream lengthStream;

    public ListJsonReader(StreamDescriptor streamDescriptor, boolean checkForNulls, DateTimeZone hiveStorageTimeZone) {
        this.streamDescriptor = (StreamDescriptor)Preconditions.checkNotNull((Object)streamDescriptor, (Object)"stream is null");
        this.checkForNulls = checkForNulls;
        this.elementReader = JsonReaders.createJsonReader(streamDescriptor.getNestedStreams().get(0), true, hiveStorageTimeZone);
    }

    @Override
    public void readNextValueInto(JsonGenerator generator) throws IOException {
        if (this.presentStream != null && !this.presentStream.nextBit()) {
            generator.writeNull();
            return;
        }
        if (this.lengthStream == null) {
            throw new OrcCorruptionException("Value is not null but length stream is not present");
        }
        long length = this.lengthStream.next();
        generator.writeStartArray();
        int i = 0;
        while ((long)i < length) {
            this.elementReader.readNextValueInto(generator);
            ++i;
        }
        generator.writeEndArray();
    }

    @Override
    public void skip(int skipSize) throws IOException {
        if (this.presentStream != null) {
            skipSize = this.presentStream.countBitsSet(skipSize);
        }
        if (skipSize == 0) {
            return;
        }
        if (this.lengthStream == null) {
            throw new OrcCorruptionException("Value is not null but length stream is not present");
        }
        long elementSkipSize = this.lengthStream.sum(skipSize);
        this.elementReader.skip(Ints.checkedCast((long)elementSkipSize));
    }

    @Override
    public void openStripe(StreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) throws IOException {
        this.presentStream = null;
        this.lengthStream = null;
        this.elementReader.openStripe(dictionaryStreamSources, encoding);
    }

    @Override
    public void openRowGroup(StreamSources dataStreamSources) throws IOException {
        if (this.checkForNulls) {
            this.presentStream = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanStream.class).openStream();
        }
        this.lengthStream = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.LENGTH, LongStream.class).openStream();
        this.elementReader.openRowGroup(dataStreamSources);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }
}

