/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.AbstractOrcDataSource;
import io.airlift.units.DataSize;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FileOrcDataSource
extends AbstractOrcDataSource {
    private final RandomAccessFile input;

    public FileOrcDataSource(File path, DataSize maxMergeDistance) throws IOException {
        this(path, maxMergeDistance, new DataSize(2.147483647E9, DataSize.Unit.BYTE), new DataSize(0.0, DataSize.Unit.BYTE));
    }

    public FileOrcDataSource(File path, DataSize maxMergeDistance, DataSize maxReadSize, DataSize streamBufferSize) throws FileNotFoundException {
        super(path.getPath(), path.length(), maxMergeDistance, maxReadSize, streamBufferSize);
        this.input = new RandomAccessFile(path, "r");
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    protected void readInternal(long position, byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
        this.input.seek(position);
        this.input.readFully(buffer, bufferOffset, bufferLength);
    }
}

