/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.hive.;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.checkpoint.InputStreamCheckpoint;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.slice.FixedLengthSliceInput;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.iq80.snappy.Snappy;
import sun.misc.Unsafe;

public final class OrcInputStream
extends InputStream {
    private final String source;
    private final FixedLengthSliceInput compressedSliceInput;
    private final CompressionKind compressionKind;
    private final int bufferSize;
    private int currentCompressedBlockOffset;
    private FixedLengthSliceInput current;
    private Slice buffer;

    public OrcInputStream(String source, FixedLengthSliceInput sliceInput, CompressionKind compressionKind, int bufferSize) {
        this.source = (String)Preconditions.checkNotNull((Object)source, (Object)"source is null");
        Preconditions.checkNotNull((Object)sliceInput, (Object)"sliceInput is null");
        this.compressionKind = (CompressionKind)((Object)Preconditions.checkNotNull((Object)((Object)compressionKind), (Object)"compressionKind is null"));
        this.bufferSize = bufferSize;
        if (compressionKind == CompressionKind.UNCOMPRESSED) {
            this.current = sliceInput;
            this.compressedSliceInput = Slices.EMPTY_SLICE.getInput();
        } else {
            Preconditions.checkArgument((compressionKind == CompressionKind.SNAPPY || compressionKind == CompressionKind.ZLIB ? 1 : 0) != 0, (String)"%s compression not supported", (Object[])new Object[]{compressionKind});
            this.compressedSliceInput = (FixedLengthSliceInput)Preconditions.checkNotNull((Object)sliceInput, (Object)"compressedSliceInput is null");
            this.current = Slices.EMPTY_SLICE.getInput();
        }
    }

    @Override
    public void close() throws IOException {
        this.current = null;
    }

    @Override
    public int available() throws IOException {
        if (this.current == null) {
            return 0;
        }
        return this.current.available();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        if (this.current == null) {
            return -1;
        }
        int result = this.current.read();
        if (result != -1) {
            return result;
        }
        this.advance();
        return this.read();
    }

    @Override
    public int read(byte[] b, int off, int length) throws IOException {
        if (this.current == null) {
            return -1;
        }
        if (this.current.remaining() == 0L) {
            this.advance();
            if (this.current == null) {
                return -1;
            }
        }
        return this.current.read(b, off, length);
    }

    public long getCheckpoint() {
        if (this.current == null || this.current.position() == 0L && this.current.remaining() == 0L) {
            return InputStreamCheckpoint.createInputStreamCheckpoint(.Ints.checkedCast((long)this.compressedSliceInput.position()), 0);
        }
        return InputStreamCheckpoint.createInputStreamCheckpoint(this.currentCompressedBlockOffset, .Ints.checkedCast((long)this.current.position()));
    }

    public boolean seekToCheckpoint(long checkpoint) throws IOException {
        boolean discardedBuffer;
        int compressedBlockOffset = InputStreamCheckpoint.decodeCompressedBlockOffset(checkpoint);
        int decompressedOffset = InputStreamCheckpoint.decodeDecompressedOffset(checkpoint);
        if (compressedBlockOffset != this.currentCompressedBlockOffset) {
            if (this.compressionKind == CompressionKind.UNCOMPRESSED) {
                throw new OrcCorruptionException("Reset stream has a compressed block offset but stream is not compressed");
            }
            this.compressedSliceInput.setPosition((long)compressedBlockOffset);
            this.current = Slices.EMPTY_SLICE.getInput();
            discardedBuffer = true;
        } else {
            discardedBuffer = false;
        }
        if ((long)decompressedOffset != this.current.position()) {
            this.current.setPosition(0L);
            if (this.current.remaining() < (long)decompressedOffset) {
                decompressedOffset = (int)((long)decompressedOffset - this.current.remaining());
                this.advance();
            }
            this.current.setPosition((long)decompressedOffset);
        }
        return discardedBuffer;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.current == null || n <= 0L) {
            return -1L;
        }
        long result = this.current.skip(n);
        if (result != 0L) {
            return result;
        }
        if (this.read() == -1) {
            return 0L;
        }
        return 1L + this.current.skip(n - 1L);
    }

    private void advance() throws IOException {
        if (this.compressedSliceInput == null || this.compressedSliceInput.remaining() == 0L) {
            this.current = null;
            return;
        }
        this.currentCompressedBlockOffset = .Ints.checkedCast((long)this.compressedSliceInput.position());
        int b0 = this.compressedSliceInput.readUnsignedByte();
        int b1 = this.compressedSliceInput.readUnsignedByte();
        int b2 = this.compressedSliceInput.readUnsignedByte();
        boolean isUncompressed = (b0 & 1) == 1;
        int chunkLength = b2 << 15 | b1 << 7 | b0 >>> 1;
        Slice chunk = this.compressedSliceInput.readSlice(chunkLength);
        if (isUncompressed) {
            this.current = chunk.getInput();
        } else {
            if (this.buffer == null) {
                this.buffer = Slices.allocate((int)this.bufferSize);
            }
            int uncompressedSize = this.compressionKind == CompressionKind.ZLIB ? OrcInputStream.decompressZip(chunk, this.buffer) : OrcInputStream.decompressSnappy(chunk, this.buffer);
            this.current = this.buffer.slice(0, uncompressedSize).getInput();
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("source", (Object)this.source).add("compressedOffset", this.compressedSliceInput.position()).add("uncompressedOffset", this.current == null ? null : Long.valueOf(this.current.position())).add("compression", (Object)this.compressionKind).toString();
    }

    private static int decompressZip(Slice in, Slice buffer) throws IOException {
        byte[] outArray = (byte[])buffer.getBase();
        int outOffset = 0;
        byte[] inArray = (byte[])in.getBase();
        int inOffset = (int)(in.getAddress() - (long)Unsafe.ARRAY_BYTE_BASE_OFFSET);
        int inLength = in.length();
        Inflater inflater = new Inflater(true);
        inflater.setInput(inArray, inOffset, inLength);
        while (!(inflater.finished() || inflater.needsDictionary() || inflater.needsInput())) {
            try {
                int count = inflater.inflate(outArray, outOffset, outArray.length - outOffset);
                outOffset += count;
            }
            catch (DataFormatException e) {
                throw new OrcCorruptionException(e, "Invalid compressed stream", new Object[0]);
            }
        }
        inflater.end();
        return outOffset;
    }

    private static int decompressSnappy(Slice in, Slice buffer) throws IOException {
        byte[] outArray = (byte[])buffer.getBase();
        byte[] inArray = (byte[])in.getBase();
        int inOffset = (int)(in.getAddress() - (long)Unsafe.ARRAY_BYTE_BASE_OFFSET);
        int inLength = in.length();
        return Snappy.uncompress((byte[])inArray, (int)inOffset, (int)inLength, (byte[])outArray, (int)0);
    }
}

