/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.checkpoint.StreamCheckpoint;
import com.facebook.presto.orc.stream.OrcStreamUtils;
import com.facebook.presto.orc.stream.StreamSource;
import com.facebook.presto.orc.stream.ValueStream;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.annotation.Nullable;

public class CheckpointStreamSource<S extends ValueStream<C>, C extends StreamCheckpoint>
implements StreamSource<S> {
    private final S stream;
    private final C checkpoint;

    public static <S extends ValueStream<C>, C extends StreamCheckpoint> CheckpointStreamSource<S, C> createCheckpointStreamSource(S stream, StreamCheckpoint checkpoint) {
        Preconditions.checkNotNull(stream, (Object)"stream is null");
        Preconditions.checkNotNull((Object)checkpoint, (Object)"checkpoint is null");
        Class<C> checkpointType = stream.getCheckpointType();
        StreamCheckpoint verifiedCheckpoint = (StreamCheckpoint)OrcStreamUtils.checkType(checkpoint, checkpointType, "Checkpoint");
        return new CheckpointStreamSource<S, StreamCheckpoint>(stream, verifiedCheckpoint);
    }

    public CheckpointStreamSource(S stream, C checkpoint) {
        this.stream = (ValueStream)Preconditions.checkNotNull(stream, (Object)"stream is null");
        this.checkpoint = (StreamCheckpoint)Preconditions.checkNotNull(checkpoint, (Object)"checkpoint is null");
    }

    @Override
    public Class<S> getStreamType() {
        return this.stream.getClass();
    }

    @Override
    @Nullable
    public S openStream() throws IOException {
        this.stream.seekToCheckpoint(this.checkpoint);
        return this.stream;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("stream", this.stream).add("checkpoint", this.checkpoint).toString();
    }
}

