/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata;

import com.facebook.presto.orc.metadata.CompressionKind;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;

public class PostScript {
    private final List<Integer> version;
    private final long footerLength;
    private final long metadataLength;
    private final CompressionKind compression;
    private final long compressionBlockSize;

    public PostScript(List<Integer> version, long footerLength, long metadataLength, CompressionKind compression, long compressionBlockSize) {
        this.version = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(version, (Object)"version is null")));
        this.footerLength = footerLength;
        this.metadataLength = metadataLength;
        this.compression = (CompressionKind)((Object)Preconditions.checkNotNull((Object)((Object)compression), (Object)"compressionKind is null"));
        this.compressionBlockSize = compressionBlockSize;
    }

    public List<Integer> getVersion() {
        return this.version;
    }

    public long getFooterLength() {
        return this.footerLength;
    }

    public long getMetadataLength() {
        return this.metadataLength;
    }

    public CompressionKind getCompression() {
        return this.compression;
    }

    public long getCompressionBlockSize() {
        return this.compressionBlockSize;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("version", this.version).add("footerLength", this.footerLength).add("metadataLength", this.metadataLength).add("compressionKind", (Object)this.compression).add("compressionBlockSize", this.compressionBlockSize).toString();
    }
}

