/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.json;

import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.json.JsonMapKeyReader;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.stream.BooleanStream;
import com.facebook.presto.orc.stream.ByteArrayStream;
import com.facebook.presto.orc.stream.LongStream;
import com.facebook.presto.orc.stream.RowGroupDictionaryLengthStream;
import com.facebook.presto.orc.stream.StreamSources;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SliceDictionaryJsonReader
implements JsonMapKeyReader {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final StreamDescriptor streamDescriptor;
    private final boolean writeBinary;
    @Nonnull
    private byte[][] dictionary = new byte[0][];
    @Nonnull
    private int[] dictionaryLength = new int[0];
    @Nonnull
    private byte[][] rowGroupDictionary = new byte[0][];
    @Nonnull
    private int[] rowGroupDictionaryLength = new int[0];
    @Nullable
    private BooleanStream presentStream;
    @Nullable
    private BooleanStream inDictionaryStream;
    @Nullable
    private LongStream dataStream;

    public SliceDictionaryJsonReader(StreamDescriptor streamDescriptor, boolean writeBinary) {
        this.streamDescriptor = (StreamDescriptor)Preconditions.checkNotNull((Object)streamDescriptor, (Object)"stream is null");
        this.writeBinary = writeBinary;
    }

    @Override
    public void readNextValueInto(JsonGenerator generator) throws IOException {
        if (this.presentStream != null && !this.presentStream.nextBit()) {
            generator.writeNull();
            return;
        }
        byte[] value = this.getNextValue();
        if (this.writeBinary) {
            generator.writeBinary(value);
        } else {
            generator.writeUTF8String(value, 0, value.length);
        }
    }

    @Override
    public String nextValueAsMapKey() throws IOException {
        if (this.presentStream != null && !this.presentStream.nextBit()) {
            return null;
        }
        byte[] value = this.getNextValue();
        if (this.writeBinary) {
            return Base64.getEncoder().encodeToString(value);
        }
        return new String(value, StandardCharsets.UTF_8);
    }

    private byte[] getNextValue() throws IOException {
        if (this.dataStream == null) {
            throw new OrcCorruptionException("Value is not null but data stream is not present");
        }
        int dictionaryIndex = Ints.checkedCast((long)this.dataStream.next());
        byte[] value = this.inDictionaryStream == null || this.inDictionaryStream.nextBit() ? this.dictionary[dictionaryIndex] : this.rowGroupDictionary[dictionaryIndex];
        return value;
    }

    @Override
    public void skip(int skipSize) throws IOException {
        if (this.presentStream != null) {
            skipSize = this.presentStream.countBitsSet(skipSize);
        }
        if (skipSize == 0) {
            return;
        }
        if (this.dataStream == null) {
            throw new OrcCorruptionException("Value is not null but data stream is not present");
        }
        if (this.inDictionaryStream != null) {
            this.inDictionaryStream.skip(skipSize);
        }
        this.dataStream.skip(skipSize);
    }

    @Override
    public void openStripe(StreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) throws IOException {
        int dictionarySize = encoding.get(this.streamDescriptor.getStreamId()).getDictionarySize();
        if (dictionarySize > 0) {
            LongStream lengthStream;
            if (this.dictionary.length < dictionarySize) {
                this.dictionary = new byte[dictionarySize][];
                this.dictionaryLength = new int[dictionarySize];
            }
            if ((lengthStream = dictionaryStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.LENGTH, LongStream.class).openStream()) == null) {
                throw new OrcCorruptionException("Dictionary is not empty but length stream is not present");
            }
            lengthStream.nextIntVector(dictionarySize, this.dictionaryLength);
            ByteArrayStream dictionaryDataStream = dictionaryStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.DICTIONARY_DATA, ByteArrayStream.class).openStream();
            SliceDictionaryJsonReader.readDictionary(dictionaryDataStream, dictionarySize, this.dictionaryLength, this.dictionary);
        }
        this.presentStream = null;
        this.dataStream = null;
        this.inDictionaryStream = null;
    }

    @Override
    public void openRowGroup(StreamSources dataStreamSources) throws IOException {
        RowGroupDictionaryLengthStream lengthStream = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.ROW_GROUP_DICTIONARY_LENGTH, RowGroupDictionaryLengthStream.class).openStream();
        if (lengthStream == null) {
            this.inDictionaryStream = null;
        } else {
            this.inDictionaryStream = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.IN_DICTIONARY, BooleanStream.class).openStream();
            int dictionaryEntryCount = lengthStream.getEntryCount();
            if (this.rowGroupDictionary.length < dictionaryEntryCount) {
                this.rowGroupDictionary = new byte[dictionaryEntryCount][];
                this.rowGroupDictionaryLength = new int[dictionaryEntryCount];
            }
            lengthStream.nextIntVector(dictionaryEntryCount, this.rowGroupDictionaryLength);
            ByteArrayStream dictionaryDataStream = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.ROW_GROUP_DICTIONARY, ByteArrayStream.class).openStream();
            SliceDictionaryJsonReader.readDictionary(dictionaryDataStream, dictionaryEntryCount, this.rowGroupDictionaryLength, this.rowGroupDictionary);
        }
        this.presentStream = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanStream.class).openStream();
        this.dataStream = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.DATA, LongStream.class).openStream();
    }

    private static void readDictionary(ByteArrayStream dictionaryDataStream, int dictionarySize, int[] dictionaryLength, byte[][] dictionary) throws IOException {
        for (int i = 0; i < dictionarySize; ++i) {
            int length = dictionaryLength[i];
            dictionary[i] = length == 0 ? EMPTY_BYTE_ARRAY : dictionaryDataStream.next(length);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }
}

