/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.DiskRange;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcPredicate;
import com.facebook.presto.orc.RowGroup;
import com.facebook.presto.orc.StreamId;
import com.facebook.presto.orc.Stripe;
import com.facebook.presto.orc.checkpoint.Checkpoints;
import com.facebook.presto.orc.checkpoint.StreamCheckpoint;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.ColumnStatistics;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.MetadataReader;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.metadata.RowGroupIndex;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.metadata.StripeFooter;
import com.facebook.presto.orc.metadata.StripeInformation;
import com.facebook.presto.orc.stream.CheckpointStreamSource;
import com.facebook.presto.orc.stream.OrcInputStream;
import com.facebook.presto.orc.stream.StreamSource;
import com.facebook.presto.orc.stream.StreamSources;
import com.facebook.presto.orc.stream.ValueStream;
import com.facebook.presto.orc.stream.ValueStreams;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import io.airlift.slice.FixedLengthSliceInput;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StripeReader {
    private final OrcDataSource orcDataSource;
    private final CompressionKind compressionKind;
    private final List<OrcType> types;
    private final int bufferSize;
    private final Set<Integer> includedOrcColumns;
    private final int rowsInRowGroup;
    private final OrcPredicate predicate;
    private final MetadataReader metadataReader;

    public StripeReader(OrcDataSource orcDataSource, CompressionKind compressionKind, List<OrcType> types, int bufferSize, Set<Integer> includedColumns, int rowsInRowGroup, OrcPredicate predicate, MetadataReader metadataReader) {
        this.orcDataSource = (OrcDataSource)Preconditions.checkNotNull((Object)orcDataSource, (Object)"orcDataSource is null");
        this.compressionKind = (CompressionKind)((Object)Preconditions.checkNotNull((Object)((Object)compressionKind), (Object)"compressionKind is null"));
        this.types = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(types, (Object)"types is null")));
        this.bufferSize = bufferSize;
        this.includedOrcColumns = StripeReader.getIncludedOrcColumns(types, (Set)Preconditions.checkNotNull(includedColumns, (Object)"includedColumns is null"));
        this.rowsInRowGroup = rowsInRowGroup;
        this.predicate = (OrcPredicate)Preconditions.checkNotNull((Object)predicate, (Object)"predicate is null");
        this.metadataReader = (MetadataReader)Preconditions.checkNotNull((Object)metadataReader, (Object)"metadataReader is null");
    }

    public Stripe readStripe(StripeInformation stripe) throws IOException {
        StripeFooter stripeFooter = this.readStripeFooter(stripe);
        List<ColumnEncoding> columnEncodings = stripeFooter.getColumnEncodings();
        HashMap<StreamId, Stream> streams = new HashMap<StreamId, Stream>();
        for (Stream stream : stripeFooter.getStreams()) {
            if (!this.includedOrcColumns.contains(stream.getColumn())) continue;
            streams.put(new StreamId(stream), stream);
        }
        Map diskRanges = StripeReader.getDiskRanges(stripeFooter.getStreams());
        diskRanges = Maps.filterKeys(diskRanges, (Predicate)Predicates.in(streams.keySet()));
        Map<StreamId, OrcInputStream> streamsData = this.readDiskRanges(stripe.getOffset(), diskRanges);
        Map<Integer, List<RowGroupIndex>> columnIndexes = this.readColumnIndexes(streams, streamsData);
        Set<Integer> selectedRowGroups = this.selectRowGroups(stripe, columnIndexes);
        if (selectedRowGroups.isEmpty()) {
            return null;
        }
        Map<StreamId, ValueStream<?>> valueStreams = this.createValueStreams(streams, streamsData, columnEncodings);
        StreamSources dictionaryStreamSources = this.createDictionaryStreamSources(streams, valueStreams, columnEncodings);
        List<RowGroup> rowGroups = this.createRowGroups(stripe.getNumberOfRows(), streams, valueStreams, columnIndexes, selectedRowGroups, columnEncodings);
        return new Stripe(stripe.getNumberOfRows(), columnEncodings, rowGroups, dictionaryStreamSources);
    }

    public Map<StreamId, OrcInputStream> readDiskRanges(long stripeOffset, Map<StreamId, DiskRange> diskRanges) throws IOException {
        diskRanges = Maps.transformValues(diskRanges, diskRange -> new DiskRange(stripeOffset + diskRange.getOffset(), diskRange.getLength()));
        Map streamsData = this.orcDataSource.readFully(diskRanges);
        return ImmutableMap.copyOf((Map)Maps.transformValues(streamsData, input -> new OrcInputStream(this.orcDataSource.toString(), (FixedLengthSliceInput)input, this.compressionKind, this.bufferSize)));
    }

    private Map<StreamId, ValueStream<?>> createValueStreams(Map<StreamId, Stream> streams, Map<StreamId, OrcInputStream> streamsData, List<ColumnEncoding> columnEncodings) {
        ImmutableMap.Builder valueStreams = ImmutableMap.builder();
        for (Map.Entry<StreamId, Stream> entry : streams.entrySet()) {
            StreamId streamId = entry.getKey();
            Stream stream = entry.getValue();
            ColumnEncoding.ColumnEncodingKind columnEncoding = columnEncodings.get(stream.getColumn()).getColumnEncodingKind();
            if (StripeReader.isIndexStream(stream) || stream.getLength() == 0) continue;
            OrcInputStream inputStream = streamsData.get(streamId);
            OrcType.OrcTypeKind columnType = this.types.get(stream.getColumn()).getOrcTypeKind();
            valueStreams.put((Object)streamId, ValueStreams.createValueStreams(streamId, inputStream, columnType, columnEncoding, stream.isUseVInts()));
        }
        return valueStreams.build();
    }

    public StreamSources createDictionaryStreamSources(Map<StreamId, Stream> streams, Map<StreamId, ValueStream<?>> valueStreams, List<ColumnEncoding> columnEncodings) {
        ImmutableMap.Builder dictionaryStreamBuilder = ImmutableMap.builder();
        for (Map.Entry<StreamId, Stream> entry : streams.entrySet()) {
            ValueStream<?> valueStream;
            int column;
            ColumnEncoding.ColumnEncodingKind columnEncoding;
            StreamId streamId = entry.getKey();
            Stream stream = entry.getValue();
            if (!StripeReader.isDictionary(stream, columnEncoding = columnEncodings.get(column = stream.getColumn()).getColumnEncodingKind()) || (valueStream = valueStreams.get(streamId)) == null) continue;
            OrcType.OrcTypeKind columnType = this.types.get(stream.getColumn()).getOrcTypeKind();
            StreamCheckpoint streamCheckpoint = Checkpoints.getDictionaryStreamCheckpoint(streamId, columnType, columnEncoding);
            CheckpointStreamSource streamSource = CheckpointStreamSource.createCheckpointStreamSource(valueStream, streamCheckpoint);
            dictionaryStreamBuilder.put((Object)streamId, streamSource);
        }
        return new StreamSources((Map<StreamId, StreamSource<?>>)dictionaryStreamBuilder.build());
    }

    private List<RowGroup> createRowGroups(int rowsInStripe, Map<StreamId, Stream> streams, Map<StreamId, ValueStream<?>> valueStreams, Map<Integer, List<RowGroupIndex>> columnIndexes, Set<Integer> selectedRowGroups, List<ColumnEncoding> encodings) {
        ImmutableList.Builder rowGroupBuilder = ImmutableList.builder();
        for (int rowGroupId : selectedRowGroups) {
            Map<StreamId, StreamCheckpoint> checkpoints = Checkpoints.getStreamCheckpoints(this.includedOrcColumns, this.types, this.compressionKind, rowGroupId, encodings, streams, columnIndexes);
            int rowsInGroup = Math.min(rowsInStripe - rowGroupId * this.rowsInRowGroup, this.rowsInRowGroup);
            rowGroupBuilder.add((Object)StripeReader.createRowGroup(rowGroupId, rowsInGroup, valueStreams, checkpoints));
        }
        return rowGroupBuilder.build();
    }

    public static RowGroup createRowGroup(int groupId, int rowCount, Map<StreamId, ValueStream<?>> valueStreams, Map<StreamId, StreamCheckpoint> checkpoints) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<StreamId, StreamCheckpoint> entry : checkpoints.entrySet()) {
            StreamId streamId = entry.getKey();
            StreamCheckpoint checkpoint = entry.getValue();
            ValueStream<?> valueStream = valueStreams.get(streamId);
            if (valueStream == null) continue;
            builder.put((Object)streamId, CheckpointStreamSource.createCheckpointStreamSource(valueStream, checkpoint));
        }
        StreamSources rowGroupStreams = new StreamSources((Map<StreamId, StreamSource<?>>)builder.build());
        return new RowGroup(groupId, rowCount, rowGroupStreams);
    }

    public StripeFooter readStripeFooter(StripeInformation stripe) throws IOException {
        long offset = stripe.getOffset() + stripe.getIndexLength() + stripe.getDataLength();
        int tailLength = Ints.checkedCast((long)stripe.getFooterLength());
        byte[] tailBuffer = new byte[tailLength];
        this.orcDataSource.readFully(offset, tailBuffer);
        OrcInputStream inputStream = new OrcInputStream(this.orcDataSource.toString(), (FixedLengthSliceInput)Slices.wrappedBuffer((byte[])tailBuffer).getInput(), this.compressionKind, this.bufferSize);
        return this.metadataReader.readStripeFooter(this.types, inputStream);
    }

    private Map<Integer, List<RowGroupIndex>> readColumnIndexes(Map<StreamId, Stream> streams, Map<StreamId, OrcInputStream> streamsData) throws IOException {
        ImmutableMap.Builder columnIndexes = ImmutableMap.builder();
        for (Map.Entry<StreamId, Stream> entry : streams.entrySet()) {
            Stream stream = entry.getValue();
            if (stream.getStreamKind() != Stream.StreamKind.ROW_INDEX) continue;
            OrcInputStream inputStream = streamsData.get(entry.getKey());
            columnIndexes.put((Object)stream.getColumn(), this.metadataReader.readRowIndexes(inputStream));
        }
        return columnIndexes.build();
    }

    private Set<Integer> selectRowGroups(StripeInformation stripe, Map<Integer, List<RowGroupIndex>> columnIndexes) throws IOException {
        int rowsInStripe = Ints.checkedCast((long)stripe.getNumberOfRows());
        int groupsInStripe = StripeReader.ceil(rowsInStripe, this.rowsInRowGroup);
        ImmutableSet.Builder selectedRowGroups = ImmutableSet.builder();
        int remainingRows = rowsInStripe;
        for (int rowGroup = 0; rowGroup < groupsInStripe; ++rowGroup) {
            Map<Integer, ColumnStatistics> statistics;
            int rows = Math.min(remainingRows, this.rowsInRowGroup);
            if (this.predicate.matches(rows, statistics = StripeReader.getRowGroupStatistics(this.types.get(0), columnIndexes, rowGroup))) {
                selectedRowGroups.add((Object)rowGroup);
            }
            remainingRows -= rows;
        }
        return selectedRowGroups.build();
    }

    private static Map<Integer, ColumnStatistics> getRowGroupStatistics(OrcType rootStructType, Map<Integer, List<RowGroupIndex>> columnIndexes, int rowGroup) {
        Preconditions.checkNotNull((Object)rootStructType, (Object)"rootStructType is null");
        Preconditions.checkArgument((rootStructType.getOrcTypeKind() == OrcType.OrcTypeKind.STRUCT ? 1 : 0) != 0);
        Preconditions.checkNotNull(columnIndexes, (Object)"columnIndexes is null");
        Preconditions.checkArgument((rowGroup >= 0 ? 1 : 0) != 0, (Object)"rowGroup is negative");
        ImmutableMap.Builder statistics = ImmutableMap.builder();
        for (int ordinal = 0; ordinal < rootStructType.getFieldCount(); ++ordinal) {
            List<RowGroupIndex> rowGroupIndexes = columnIndexes.get(rootStructType.getFieldTypeIndex(ordinal));
            if (rowGroupIndexes == null) continue;
            statistics.put((Object)ordinal, (Object)rowGroupIndexes.get(rowGroup).getColumnStatistics());
        }
        return statistics.build();
    }

    private static boolean isIndexStream(Stream stream) {
        return stream.getStreamKind() == Stream.StreamKind.ROW_INDEX || stream.getStreamKind() == Stream.StreamKind.DICTIONARY_COUNT;
    }

    private static boolean isDictionary(Stream stream, ColumnEncoding.ColumnEncodingKind columnEncoding) {
        return stream.getStreamKind() == Stream.StreamKind.DICTIONARY_DATA || stream.getStreamKind() == Stream.StreamKind.LENGTH && (columnEncoding == ColumnEncoding.ColumnEncodingKind.DICTIONARY || columnEncoding == ColumnEncoding.ColumnEncodingKind.DICTIONARY_V2);
    }

    private static Map<StreamId, DiskRange> getDiskRanges(List<Stream> streams) {
        ImmutableMap.Builder streamDiskRanges = ImmutableMap.builder();
        long stripeOffset = 0L;
        for (Stream stream : streams) {
            int streamLength = Ints.checkedCast((long)stream.getLength());
            streamDiskRanges.put((Object)new StreamId(stream), (Object)new DiskRange(stripeOffset, streamLength));
            stripeOffset += (long)streamLength;
        }
        return streamDiskRanges.build();
    }

    private static Set<Integer> getIncludedOrcColumns(List<OrcType> types, Set<Integer> includedColumns) {
        LinkedHashSet<Integer> includes = new LinkedHashSet<Integer>();
        OrcType root = types.get(0);
        for (int includedColumn : includedColumns) {
            StripeReader.includeOrcColumnsRecursive(types, includes, root.getFieldTypeIndex(includedColumn));
        }
        return includes;
    }

    private static void includeOrcColumnsRecursive(List<OrcType> types, Set<Integer> result, int typeId) {
        result.add(typeId);
        OrcType type = types.get(typeId);
        int children = type.getFieldCount();
        for (int i = 0; i < children; ++i) {
            StripeReader.includeOrcColumnsRecursive(types, result, type.getFieldTypeIndex(i));
        }
    }

    private static int ceil(int dividend, int divisor) {
        return (dividend + divisor - 1) / divisor;
    }
}

