/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.OrcCorruptionException;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;

final class OrcStreamUtils {
    public static final int MIN_REPEAT_SIZE = 3;

    private OrcStreamUtils() {
    }

    public static void skipFully(InputStream input, long length) throws IOException {
        while (length > 0L) {
            long result = input.skip(length);
            if (result < 0L) {
                throw new OrcCorruptionException("Unexpected end of stream");
            }
            length -= result;
        }
    }

    public static void readFully(InputStream input, byte[] buffer, int offset, int length) throws IOException {
        while (offset < length) {
            int result = input.read(buffer, offset, length - offset);
            if (result < 0) {
                throw new OrcCorruptionException("Unexpected end of stream");
            }
            offset += result;
        }
    }

    static <A, B extends A> B checkType(A value, Class<B> target, String name) {
        Preconditions.checkNotNull(value, (String)"%s is null", (Object[])new Object[]{name});
        Preconditions.checkArgument((boolean)target.isInstance(value), (String)"%s must be of type %s, not %s", (Object[])new Object[]{name, target.getName(), value.getClass().getName()});
        return target.cast(value);
    }
}

