/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.SliceVector;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.reader.StreamReader;
import com.facebook.presto.orc.stream.BooleanStream;
import com.facebook.presto.orc.stream.ByteArrayStream;
import com.facebook.presto.orc.stream.LongStream;
import com.facebook.presto.orc.stream.MissingStreamSource;
import com.facebook.presto.orc.stream.RowGroupDictionaryLengthStream;
import com.facebook.presto.orc.stream.StreamSource;
import com.facebook.presto.orc.stream.StreamSources;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SliceDictionaryStreamReader
implements StreamReader {
    private final StreamDescriptor streamDescriptor;
    private int readOffset;
    private int nextBatchSize;
    @Nonnull
    private StreamSource<BooleanStream> presentStreamSource = MissingStreamSource.missingStreamSource(BooleanStream.class);
    @Nullable
    private BooleanStream presentStream;
    private final boolean[] isNullVector = new boolean[1024];
    @Nonnull
    private StreamSource<ByteArrayStream> dictionaryDataStreamSource = MissingStreamSource.missingStreamSource(ByteArrayStream.class);
    private boolean dictionaryOpen;
    private int dictionarySize;
    @Nonnull
    private Slice[] dictionary = new Slice[0];
    @Nonnull
    private StreamSource<LongStream> dictionaryLengthStreamSource = MissingStreamSource.missingStreamSource(LongStream.class);
    @Nonnull
    private int[] dictionaryLength = new int[0];
    @Nonnull
    private StreamSource<BooleanStream> inDictionaryStreamSource = MissingStreamSource.missingStreamSource(BooleanStream.class);
    @Nullable
    private BooleanStream inDictionaryStream;
    private final boolean[] inDictionary = new boolean[1024];
    @Nonnull
    private StreamSource<ByteArrayStream> rowGroupDictionaryDataStreamSource = MissingStreamSource.missingStreamSource(ByteArrayStream.class);
    @Nonnull
    private Slice[] rowGroupDictionary = new Slice[0];
    @Nonnull
    private StreamSource<RowGroupDictionaryLengthStream> rowGroupDictionaryLengthStreamSource = MissingStreamSource.missingStreamSource(RowGroupDictionaryLengthStream.class);
    @Nonnull
    private int[] rowGroupDictionaryLength = new int[0];
    @Nonnull
    private StreamSource<LongStream> dataStreamSource = MissingStreamSource.missingStreamSource(LongStream.class);
    @Nullable
    private LongStream dataStream;
    @Nonnull
    private final int[] dataVector = new int[1024];
    private boolean rowGroupOpen;

    public SliceDictionaryStreamReader(StreamDescriptor streamDescriptor) {
        this.streamDescriptor = (StreamDescriptor)Preconditions.checkNotNull((Object)streamDescriptor, (Object)"stream is null");
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public void readBatch(Object vector) throws IOException {
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            if (this.readOffset > 0) {
                if (this.dataStream == null) {
                    throw new OrcCorruptionException("Value is not null but data stream is not present");
                }
                if (this.inDictionaryStream != null) {
                    this.inDictionaryStream.skip(this.readOffset);
                }
                this.dataStream.skip(this.readOffset);
            }
        }
        SliceVector sliceVector = (SliceVector)vector;
        if (this.presentStream == null) {
            if (this.dataStream == null) {
                throw new OrcCorruptionException("Value is not null but data stream is not present");
            }
            Arrays.fill(this.isNullVector, false);
            this.dataStream.nextIntVector(this.nextBatchSize, this.dataVector);
        } else {
            int nullValues = this.presentStream.getUnsetBits(this.nextBatchSize, this.isNullVector);
            if (nullValues != this.nextBatchSize) {
                if (this.dataStream == null) {
                    throw new OrcCorruptionException("Value is not null but data stream is not present");
                }
                this.dataStream.nextIntVector(this.nextBatchSize, this.dataVector, this.isNullVector);
            }
        }
        if (this.inDictionaryStream == null) {
            Arrays.fill(this.inDictionary, true);
        } else {
            this.inDictionaryStream.getSetBits(this.nextBatchSize, this.inDictionary, this.isNullVector);
        }
        for (int i = 0; i < this.nextBatchSize; ++i) {
            sliceVector.vector[i] = this.isNullVector[i] ? null : (this.inDictionary[i] ? this.dictionary[this.dataVector[i]] : this.rowGroupDictionary[this.dataVector[i]]);
        }
        this.readOffset = 0;
        this.nextBatchSize = 0;
    }

    private void openRowGroup() throws IOException {
        if (!this.dictionaryOpen && this.dictionarySize > 0) {
            LongStream lengthStream;
            if (this.dictionary.length < this.dictionarySize) {
                this.dictionary = new Slice[this.dictionarySize];
                this.dictionaryLength = new int[this.dictionarySize];
            }
            if ((lengthStream = this.dictionaryLengthStreamSource.openStream()) == null) {
                throw new OrcCorruptionException("Dictionary is not empty but dictionary length stream is not present");
            }
            lengthStream.nextIntVector(this.dictionarySize, this.dictionaryLength);
            ByteArrayStream dictionaryDataStream = this.dictionaryDataStreamSource.openStream();
            SliceDictionaryStreamReader.readDictionary(dictionaryDataStream, this.dictionarySize, this.dictionaryLength, this.dictionary);
        }
        this.dictionaryOpen = true;
        RowGroupDictionaryLengthStream dictionaryLengthStream = this.rowGroupDictionaryLengthStreamSource.openStream();
        if (dictionaryLengthStream != null) {
            int rowGroupDictionarySize = dictionaryLengthStream.getEntryCount();
            if (this.rowGroupDictionary.length < rowGroupDictionarySize) {
                this.rowGroupDictionary = new Slice[rowGroupDictionarySize];
                this.rowGroupDictionaryLength = new int[rowGroupDictionarySize];
            }
            dictionaryLengthStream.nextIntVector(rowGroupDictionarySize, this.rowGroupDictionaryLength);
            ByteArrayStream dictionaryDataStream = this.rowGroupDictionaryDataStreamSource.openStream();
            SliceDictionaryStreamReader.readDictionary(dictionaryDataStream, rowGroupDictionarySize, this.rowGroupDictionaryLength, this.rowGroupDictionary);
        }
        this.dictionaryOpen = true;
        this.presentStream = this.presentStreamSource.openStream();
        this.inDictionaryStream = this.inDictionaryStreamSource.openStream();
        this.dataStream = this.dataStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    private static void readDictionary(@Nullable ByteArrayStream dictionaryDataStream, int dictionarySize, int[] dictionaryLength, Slice[] dictionary) throws IOException {
        int totalLength = 0;
        for (int i = 0; i < dictionarySize; ++i) {
            totalLength += dictionaryLength[i];
        }
        byte[] dictionaryData = new byte[]{};
        if (totalLength > 0) {
            if (dictionaryDataStream == null) {
                throw new OrcCorruptionException("Dictionary length is not zero but dictionary data stream is not present");
            }
            dictionaryData = dictionaryDataStream.next(totalLength);
        }
        int offset = 0;
        for (int i = 0; i < dictionarySize; ++i) {
            int length = dictionaryLength[i];
            dictionary[i] = Slices.wrappedBuffer((byte[])dictionaryData, (int)offset, (int)length);
            offset += length;
        }
    }

    @Override
    public void startStripe(StreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) throws IOException {
        this.dictionaryDataStreamSource = dictionaryStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.DICTIONARY_DATA, ByteArrayStream.class);
        this.dictionaryLengthStreamSource = dictionaryStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.LENGTH, LongStream.class);
        this.dictionarySize = encoding.get(this.streamDescriptor.getStreamId()).getDictionarySize();
        this.dictionaryOpen = false;
        this.presentStreamSource = MissingStreamSource.missingStreamSource(BooleanStream.class);
        this.dataStreamSource = MissingStreamSource.missingStreamSource(LongStream.class);
        this.inDictionaryStreamSource = MissingStreamSource.missingStreamSource(BooleanStream.class);
        this.rowGroupDictionaryLengthStreamSource = MissingStreamSource.missingStreamSource(RowGroupDictionaryLengthStream.class);
        this.rowGroupDictionaryDataStreamSource = MissingStreamSource.missingStreamSource(ByteArrayStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.inDictionaryStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void startRowGroup(StreamSources dataStreamSources) throws IOException {
        this.presentStreamSource = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanStream.class);
        this.dataStreamSource = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.DATA, LongStream.class);
        this.inDictionaryStreamSource = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.IN_DICTIONARY, BooleanStream.class);
        this.rowGroupDictionaryLengthStreamSource = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.ROW_GROUP_DICTIONARY_LENGTH, RowGroupDictionaryLengthStream.class);
        this.rowGroupDictionaryDataStreamSource = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.ROW_GROUP_DICTIONARY, ByteArrayStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.inDictionaryStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }
}

