/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata;

import com.facebook.hive.orc.OrcProto;
import com.facebook.presto.orc.metadata.BooleanStatistics;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.ColumnStatistics;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.DoubleStatistics;
import com.facebook.presto.orc.metadata.Footer;
import com.facebook.presto.orc.metadata.IntegerStatistics;
import com.facebook.presto.orc.metadata.Metadata;
import com.facebook.presto.orc.metadata.MetadataReader;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.metadata.PostScript;
import com.facebook.presto.orc.metadata.RowGroupIndex;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.metadata.StringStatistics;
import com.facebook.presto.orc.metadata.StripeFooter;
import com.facebook.presto.orc.metadata.StripeInformation;
import com.facebook.presto.orc.metadata.StripeStatistics;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import com.google.protobuf.CodedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class DwrfMetadataReader
implements MetadataReader {
    @Override
    public PostScript readPostScript(byte[] data, int offset, int length) throws IOException {
        CodedInputStream input = CodedInputStream.newInstance((byte[])data, (int)offset, (int)length);
        OrcProto.PostScript postScript = OrcProto.PostScript.parseFrom((CodedInputStream)input);
        return new PostScript((List<Integer>)ImmutableList.of(), postScript.getFooterLength(), 0L, DwrfMetadataReader.toCompression(postScript.getCompression()), postScript.getCompressionBlockSize());
    }

    @Override
    public Metadata readMetadata(InputStream inputStream) throws IOException {
        return new Metadata((List<StripeStatistics>)ImmutableList.of());
    }

    @Override
    public Footer readFooter(InputStream inputStream) throws IOException {
        CodedInputStream input = CodedInputStream.newInstance((InputStream)inputStream);
        OrcProto.Footer footer = OrcProto.Footer.parseFrom((CodedInputStream)input);
        return new Footer(footer.getNumberOfRows(), footer.getRowIndexStride(), DwrfMetadataReader.toStripeInformation(footer.getStripesList()), DwrfMetadataReader.toType(footer.getTypesList()), DwrfMetadataReader.toColumnStatistics(footer.getStatisticsList(), false));
    }

    private static List<StripeInformation> toStripeInformation(List<OrcProto.StripeInformation> types) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(types, (Function)new Function<OrcProto.StripeInformation, StripeInformation>(){

            public StripeInformation apply(OrcProto.StripeInformation type) {
                return DwrfMetadataReader.toStripeInformation(type);
            }
        }));
    }

    private static StripeInformation toStripeInformation(OrcProto.StripeInformation stripeInformation) {
        return new StripeInformation(Ints.checkedCast((long)stripeInformation.getNumberOfRows()), stripeInformation.getOffset(), stripeInformation.getIndexLength(), stripeInformation.getDataLength(), stripeInformation.getFooterLength());
    }

    @Override
    public StripeFooter readStripeFooter(List<OrcType> types, InputStream inputStream) throws IOException {
        CodedInputStream input = CodedInputStream.newInstance((InputStream)inputStream);
        OrcProto.StripeFooter stripeFooter = OrcProto.StripeFooter.parseFrom((CodedInputStream)input);
        return new StripeFooter(DwrfMetadataReader.toStream(stripeFooter.getStreamsList()), DwrfMetadataReader.toColumnEncoding(types, stripeFooter.getColumnsList()));
    }

    private static Stream toStream(OrcProto.Stream stream) {
        return new Stream(stream.getColumn(), DwrfMetadataReader.toStreamKind(stream.getKind()), Ints.checkedCast((long)stream.getLength()), stream.getUseVInts());
    }

    private static List<Stream> toStream(List<OrcProto.Stream> streams) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(streams, (Function)new Function<OrcProto.Stream, Stream>(){

            public Stream apply(OrcProto.Stream stream) {
                return DwrfMetadataReader.toStream(stream);
            }
        }));
    }

    private static ColumnEncoding toColumnEncoding(OrcType.OrcTypeKind type, OrcProto.ColumnEncoding columnEncoding) {
        return new ColumnEncoding(DwrfMetadataReader.toColumnEncodingKind(type, columnEncoding.getKind()), columnEncoding.getDictionarySize());
    }

    private static List<ColumnEncoding> toColumnEncoding(List<OrcType> types, List<OrcProto.ColumnEncoding> columnEncodings) {
        Preconditions.checkArgument((types.size() == columnEncodings.size() ? 1 : 0) != 0);
        ImmutableList.Builder encodings = ImmutableList.builder();
        for (int i = 0; i < types.size(); ++i) {
            OrcType type = types.get(i);
            encodings.add((Object)DwrfMetadataReader.toColumnEncoding(type.getOrcTypeKind(), columnEncodings.get(i)));
        }
        return encodings.build();
    }

    @Override
    public List<RowGroupIndex> readRowIndexes(InputStream inputStream) throws IOException {
        CodedInputStream input = CodedInputStream.newInstance((InputStream)inputStream);
        OrcProto.RowIndex rowIndex = OrcProto.RowIndex.parseFrom((CodedInputStream)input);
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)rowIndex.getEntryList(), (Function)new Function<OrcProto.RowIndexEntry, RowGroupIndex>(){

            public RowGroupIndex apply(OrcProto.RowIndexEntry rowIndexEntry) {
                return DwrfMetadataReader.toRowGroupIndex(rowIndexEntry);
            }
        }));
    }

    private static RowGroupIndex toRowGroupIndex(OrcProto.RowIndexEntry rowIndexEntry) {
        List positionsList = rowIndexEntry.getPositionsList();
        ImmutableList.Builder positions = ImmutableList.builder();
        for (int index = 0; index < positionsList.size(); ++index) {
            long longPosition = (Long)positionsList.get(index);
            int intPosition = (int)longPosition;
            Preconditions.checkState(((long)intPosition == longPosition ? 1 : 0) != 0, (String)"Expected checkpoint position %s, to be an integer", (Object[])new Object[]{index});
            positions.add((Object)intPosition);
        }
        return new RowGroupIndex((List<Integer>)positions.build(), DwrfMetadataReader.toColumnStatistics(rowIndexEntry.getStatistics(), true));
    }

    private static List<ColumnStatistics> toColumnStatistics(List<OrcProto.ColumnStatistics> columnStatistics, final boolean isRowGroup) {
        if (columnStatistics == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Iterable)Iterables.transform(columnStatistics, (Function)new Function<OrcProto.ColumnStatistics, ColumnStatistics>(){

            public ColumnStatistics apply(OrcProto.ColumnStatistics columnStatistics) {
                return DwrfMetadataReader.toColumnStatistics(columnStatistics, isRowGroup);
            }
        }));
    }

    private static ColumnStatistics toColumnStatistics(OrcProto.ColumnStatistics statistics, boolean isRowGroup) {
        return new ColumnStatistics(statistics.getNumberOfValues(), DwrfMetadataReader.toBooleanStatistics(statistics.getBucketStatistics()), DwrfMetadataReader.toIntegerStatistics(statistics.getIntStatistics()), DwrfMetadataReader.toDoubleStatistics(statistics.getDoubleStatistics()), DwrfMetadataReader.toStringStatistics(statistics.getStringStatistics(), isRowGroup), null);
    }

    private static BooleanStatistics toBooleanStatistics(OrcProto.BucketStatistics bucketStatistics) {
        if (bucketStatistics.getCountCount() == 0) {
            return null;
        }
        return new BooleanStatistics(bucketStatistics.getCount(0));
    }

    private static IntegerStatistics toIntegerStatistics(OrcProto.IntegerStatistics integerStatistics) {
        if (!integerStatistics.hasMinimum() && !integerStatistics.hasMaximum()) {
            return null;
        }
        return new IntegerStatistics(integerStatistics.hasMinimum() ? Long.valueOf(integerStatistics.getMinimum()) : null, integerStatistics.hasMaximum() ? Long.valueOf(integerStatistics.getMaximum()) : null);
    }

    private static DoubleStatistics toDoubleStatistics(OrcProto.DoubleStatistics doubleStatistics) {
        if (!doubleStatistics.hasMinimum() && !doubleStatistics.hasMaximum()) {
            return null;
        }
        if (doubleStatistics.hasMinimum() && Double.isNaN(doubleStatistics.getMinimum()) || doubleStatistics.hasMaximum() && Double.isNaN(doubleStatistics.getMaximum())) {
            return null;
        }
        return new DoubleStatistics(doubleStatistics.hasMinimum() ? Double.valueOf(doubleStatistics.getMinimum()) : null, doubleStatistics.hasMaximum() ? Double.valueOf(doubleStatistics.getMaximum()) : null);
    }

    private static StringStatistics toStringStatistics(OrcProto.StringStatistics stringStatistics, boolean isRowGroup) {
        if (!isRowGroup) {
            return null;
        }
        if (!stringStatistics.hasMinimum() && !stringStatistics.hasMaximum()) {
            return null;
        }
        return null;
    }

    private static OrcType toType(OrcProto.Type type) {
        return new OrcType(DwrfMetadataReader.toTypeKind(type.getKind()), type.getSubtypesList(), type.getFieldNamesList());
    }

    private static List<OrcType> toType(List<OrcProto.Type> types) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(types, (Function)new Function<OrcProto.Type, OrcType>(){

            public OrcType apply(OrcProto.Type type) {
                return DwrfMetadataReader.toType(type);
            }
        }));
    }

    private static OrcType.OrcTypeKind toTypeKind(OrcProto.Type.Kind kind) {
        switch (kind) {
            case BOOLEAN: {
                return OrcType.OrcTypeKind.BOOLEAN;
            }
            case BYTE: {
                return OrcType.OrcTypeKind.BYTE;
            }
            case SHORT: {
                return OrcType.OrcTypeKind.SHORT;
            }
            case INT: {
                return OrcType.OrcTypeKind.INT;
            }
            case LONG: {
                return OrcType.OrcTypeKind.LONG;
            }
            case FLOAT: {
                return OrcType.OrcTypeKind.FLOAT;
            }
            case DOUBLE: {
                return OrcType.OrcTypeKind.DOUBLE;
            }
            case STRING: {
                return OrcType.OrcTypeKind.STRING;
            }
            case BINARY: {
                return OrcType.OrcTypeKind.BINARY;
            }
            case TIMESTAMP: {
                return OrcType.OrcTypeKind.TIMESTAMP;
            }
            case LIST: {
                return OrcType.OrcTypeKind.LIST;
            }
            case MAP: {
                return OrcType.OrcTypeKind.MAP;
            }
            case STRUCT: {
                return OrcType.OrcTypeKind.STRUCT;
            }
            case UNION: {
                return OrcType.OrcTypeKind.UNION;
            }
        }
        throw new IllegalArgumentException(kind + " data type not implemented yet");
    }

    private static Stream.StreamKind toStreamKind(OrcProto.Stream.Kind kind) {
        switch (kind) {
            case PRESENT: {
                return Stream.StreamKind.PRESENT;
            }
            case DATA: {
                return Stream.StreamKind.DATA;
            }
            case LENGTH: {
                return Stream.StreamKind.LENGTH;
            }
            case DICTIONARY_DATA: {
                return Stream.StreamKind.DICTIONARY_DATA;
            }
            case DICTIONARY_COUNT: {
                return Stream.StreamKind.DICTIONARY_COUNT;
            }
            case NANO_DATA: {
                return Stream.StreamKind.SECONDARY;
            }
            case ROW_INDEX: {
                return Stream.StreamKind.ROW_INDEX;
            }
            case IN_DICTIONARY: {
                return Stream.StreamKind.IN_DICTIONARY;
            }
            case STRIDE_DICTIONARY: {
                return Stream.StreamKind.ROW_GROUP_DICTIONARY;
            }
            case STRIDE_DICTIONARY_LENGTH: {
                return Stream.StreamKind.ROW_GROUP_DICTIONARY_LENGTH;
            }
        }
        throw new IllegalArgumentException(kind + " stream type not implemented yet");
    }

    private static ColumnEncoding.ColumnEncodingKind toColumnEncodingKind(OrcType.OrcTypeKind type, OrcProto.ColumnEncoding.Kind kind) {
        switch (kind) {
            case DIRECT: {
                if (type == OrcType.OrcTypeKind.SHORT || type == OrcType.OrcTypeKind.INT || type == OrcType.OrcTypeKind.LONG) {
                    return ColumnEncoding.ColumnEncodingKind.DWRF_DIRECT;
                }
                return ColumnEncoding.ColumnEncodingKind.DIRECT;
            }
            case DICTIONARY: {
                return ColumnEncoding.ColumnEncodingKind.DICTIONARY;
            }
        }
        throw new IllegalArgumentException(kind + " stream encoding not implemented yet");
    }

    private static CompressionKind toCompression(OrcProto.CompressionKind compression) {
        switch (compression) {
            case NONE: {
                return CompressionKind.UNCOMPRESSED;
            }
            case ZLIB: {
                return CompressionKind.ZLIB;
            }
            case SNAPPY: {
                return CompressionKind.SNAPPY;
            }
        }
        throw new IllegalArgumentException(compression + " compression not implemented yet");
    }
}

