/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.reader.BooleanStreamReader;
import com.facebook.presto.orc.reader.ByteStreamReader;
import com.facebook.presto.orc.reader.DoubleStreamReader;
import com.facebook.presto.orc.reader.FloatStreamReader;
import com.facebook.presto.orc.reader.JsonStreamReader;
import com.facebook.presto.orc.reader.LongStreamReader;
import com.facebook.presto.orc.reader.SliceStreamReader;
import com.facebook.presto.orc.reader.StreamReader;
import com.facebook.presto.orc.reader.TimestampStreamReader;
import org.joda.time.DateTimeZone;

public final class StreamReaders {
    private StreamReaders() {
    }

    public static StreamReader createStreamReader(StreamDescriptor streamDescriptor, DateTimeZone hiveStorageTimeZone, DateTimeZone sessionTimeZone) {
        switch (streamDescriptor.getStreamType()) {
            case BOOLEAN: {
                return new BooleanStreamReader(streamDescriptor);
            }
            case BYTE: {
                return new ByteStreamReader(streamDescriptor);
            }
            case SHORT: 
            case INT: 
            case LONG: 
            case DATE: {
                return new LongStreamReader(streamDescriptor);
            }
            case FLOAT: {
                return new FloatStreamReader(streamDescriptor);
            }
            case DOUBLE: {
                return new DoubleStreamReader(streamDescriptor);
            }
            case BINARY: 
            case STRING: {
                return new SliceStreamReader(streamDescriptor);
            }
            case TIMESTAMP: {
                return new TimestampStreamReader(streamDescriptor, hiveStorageTimeZone);
            }
            case STRUCT: 
            case LIST: 
            case MAP: {
                return new JsonStreamReader(streamDescriptor, hiveStorageTimeZone, sessionTimeZone);
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)streamDescriptor.getStreamType()));
    }
}

