/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.orc.LongVector;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.reader.StreamReader;
import com.facebook.presto.orc.stream.BooleanStream;
import com.facebook.presto.orc.stream.LongStream;
import com.facebook.presto.orc.stream.MissingStreamSource;
import com.facebook.presto.orc.stream.StreamSource;
import com.facebook.presto.orc.stream.StreamSources;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LongDictionaryStreamReader
implements StreamReader {
    private final StreamDescriptor streamDescriptor;
    private int readOffset;
    private int nextBatchSize;
    @Nonnull
    private StreamSource<BooleanStream> presentStreamSource = MissingStreamSource.missingStreamSource(BooleanStream.class);
    @Nullable
    private BooleanStream presentStream;
    @Nonnull
    private StreamSource<LongStream> dictionaryDataStreamSource = MissingStreamSource.missingStreamSource(LongStream.class);
    private int dictionarySize;
    @Nonnull
    private long[] dictionary = new long[0];
    @Nonnull
    private StreamSource<BooleanStream> inDictionaryStreamSource = MissingStreamSource.missingStreamSource(BooleanStream.class);
    @Nullable
    private BooleanStream inDictionaryStream;
    private final boolean[] inDictionary = new boolean[1024];
    @Nonnull
    private StreamSource<LongStream> dataStreamSource;
    @Nullable
    private LongStream dataStream;
    private boolean dictionaryOpen;
    private boolean rowGroupOpen;

    public LongDictionaryStreamReader(StreamDescriptor streamDescriptor) {
        this.streamDescriptor = (StreamDescriptor)Preconditions.checkNotNull((Object)streamDescriptor, (Object)"stream is null");
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public void readBatch(Object vector) throws IOException {
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            if (this.inDictionaryStream != null) {
                this.inDictionaryStream.skip(this.readOffset);
            }
            if (this.readOffset > 0) {
                OrcCorruptionException.verifyFormat(this.dataStream != null, "Value is not null but data stream is not present", new Object[0]);
                this.dataStream.skip(this.readOffset);
            }
        }
        LongVector longVector = (LongVector)vector;
        if (this.presentStream == null) {
            OrcCorruptionException.verifyFormat(this.dataStream != null, "Value is not null but data stream is not present", new Object[0]);
            Arrays.fill(longVector.isNull, false);
            this.dataStream.nextLongVector(this.nextBatchSize, longVector.vector);
        } else {
            int nullValues = this.presentStream.getUnsetBits(this.nextBatchSize, longVector.isNull);
            if (nullValues != this.nextBatchSize) {
                OrcCorruptionException.verifyFormat(this.dataStream != null, "Value is not null but data stream is not present", new Object[0]);
                this.dataStream.nextLongVector(this.nextBatchSize, longVector.vector, longVector.isNull);
            }
        }
        if (this.inDictionaryStream == null) {
            Arrays.fill(this.inDictionary, true);
        } else {
            this.inDictionaryStream.getSetBits(this.nextBatchSize, this.inDictionary, longVector.isNull);
        }
        for (int i = 0; i < this.nextBatchSize; ++i) {
            if (longVector.isNull[i] || !this.inDictionary[i]) continue;
            longVector.vector[i] = this.dictionary[(int)longVector.vector[i]];
        }
        this.readOffset = 0;
        this.nextBatchSize = 0;
    }

    private void openRowGroup() throws IOException {
        if (!this.dictionaryOpen && this.dictionarySize > 0) {
            LongStream dictionaryStream;
            if (this.dictionary.length < this.dictionarySize) {
                this.dictionary = new long[this.dictionarySize];
            }
            OrcCorruptionException.verifyFormat((dictionaryStream = this.dictionaryDataStreamSource.openStream()) != null, "Dictionary is not empty but data stream is not present", new Object[0]);
            dictionaryStream.nextLongVector(this.dictionarySize, this.dictionary);
        }
        this.dictionaryOpen = true;
        this.presentStream = this.presentStreamSource.openStream();
        this.inDictionaryStream = this.inDictionaryStreamSource.openStream();
        this.dataStream = this.dataStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    @Override
    public void startStripe(StreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) throws IOException {
        this.dictionaryDataStreamSource = dictionaryStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.DICTIONARY_DATA, LongStream.class);
        this.dictionarySize = encoding.get(this.streamDescriptor.getStreamId()).getDictionarySize();
        this.dictionaryOpen = false;
        this.inDictionaryStreamSource = MissingStreamSource.missingStreamSource(BooleanStream.class);
        this.presentStreamSource = MissingStreamSource.missingStreamSource(BooleanStream.class);
        this.dataStreamSource = MissingStreamSource.missingStreamSource(LongStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.inDictionaryStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void startRowGroup(StreamSources dataStreamSources) throws IOException {
        this.presentStreamSource = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanStream.class);
        this.inDictionaryStreamSource = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.IN_DICTIONARY, BooleanStream.class);
        this.dataStreamSource = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.DATA, LongStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.inDictionaryStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }
}

