/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.orc.DoubleVector;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.reader.StreamReader;
import com.facebook.presto.orc.stream.BooleanStream;
import com.facebook.presto.orc.stream.DoubleStream;
import com.facebook.presto.orc.stream.MissingStreamSource;
import com.facebook.presto.orc.stream.StreamSource;
import com.facebook.presto.orc.stream.StreamSources;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DoubleStreamReader
implements StreamReader {
    private final StreamDescriptor streamDescriptor;
    private int readOffset;
    private int nextBatchSize;
    @Nonnull
    private StreamSource<BooleanStream> presentStreamSource = MissingStreamSource.missingStreamSource(BooleanStream.class);
    @Nullable
    private BooleanStream presentStream;
    @Nonnull
    private StreamSource<DoubleStream> dataStreamSource = MissingStreamSource.missingStreamSource(DoubleStream.class);
    @Nullable
    private DoubleStream dataStream;
    private boolean rowGroupOpen;

    public DoubleStreamReader(StreamDescriptor streamDescriptor) {
        this.streamDescriptor = (StreamDescriptor)Preconditions.checkNotNull((Object)streamDescriptor, (Object)"stream is null");
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public void readBatch(Object vector) throws IOException {
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            if (this.readOffset > 0) {
                OrcCorruptionException.verifyFormat(this.dataStream != null, "Value is not null but data stream is not present", new Object[0]);
                this.dataStream.skip(this.readOffset);
            }
        }
        DoubleVector doubleVector = (DoubleVector)vector;
        if (this.presentStream == null) {
            OrcCorruptionException.verifyFormat(this.dataStream != null, "Value is not null but data stream is not present", new Object[0]);
            Arrays.fill(doubleVector.isNull, false);
            this.dataStream.nextVector(this.nextBatchSize, doubleVector.vector);
        } else {
            int nullValues = this.presentStream.getUnsetBits(this.nextBatchSize, doubleVector.isNull);
            if (nullValues != this.nextBatchSize) {
                OrcCorruptionException.verifyFormat(this.dataStream != null, "Value is not null but data stream is not present", new Object[0]);
                this.dataStream.nextVector(this.nextBatchSize, doubleVector.vector, doubleVector.isNull);
            }
        }
        this.readOffset = 0;
        this.nextBatchSize = 0;
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.dataStream = this.dataStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    @Override
    public void startStripe(StreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) throws IOException {
        this.presentStreamSource = MissingStreamSource.missingStreamSource(BooleanStream.class);
        this.dataStreamSource = MissingStreamSource.missingStreamSource(DoubleStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void startRowGroup(StreamSources dataStreamSources) throws IOException {
        this.presentStreamSource = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanStream.class);
        this.dataStreamSource = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.DATA, DoubleStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }
}

