/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata;

import com.facebook.presto.hive.shaded.com.google.protobuf.CodedInputStream;
import com.facebook.presto.orc.metadata.BooleanStatistics;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.ColumnStatistics;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.DateStatistics;
import com.facebook.presto.orc.metadata.DoubleStatistics;
import com.facebook.presto.orc.metadata.Footer;
import com.facebook.presto.orc.metadata.IntegerStatistics;
import com.facebook.presto.orc.metadata.Metadata;
import com.facebook.presto.orc.metadata.MetadataReader;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.metadata.PostScript;
import com.facebook.presto.orc.metadata.RowGroupIndex;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.metadata.StringStatistics;
import com.facebook.presto.orc.metadata.StripeFooter;
import com.facebook.presto.orc.metadata.StripeInformation;
import com.facebook.presto.orc.metadata.StripeStatistics;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.hadoop.hive.ql.io.orc.OrcProto;

public class OrcMetadataReader
implements MetadataReader {
    @Override
    public PostScript readPostScript(byte[] data, int offset, int length) throws IOException {
        CodedInputStream input = CodedInputStream.newInstance((byte[])data, (int)offset, (int)length);
        OrcProto.PostScript postScript = OrcProto.PostScript.parseFrom((CodedInputStream)input);
        return new PostScript(postScript.getVersionList(), postScript.getFooterLength(), postScript.getMetadataLength(), OrcMetadataReader.toCompression(postScript.getCompression()), postScript.getCompressionBlockSize());
    }

    @Override
    public Metadata readMetadata(InputStream inputStream) throws IOException {
        CodedInputStream input = CodedInputStream.newInstance((InputStream)inputStream);
        OrcProto.Metadata metadata = OrcProto.Metadata.parseFrom((CodedInputStream)input);
        return new Metadata(OrcMetadataReader.toStripeStatistics(metadata.getStripeStatsList()));
    }

    private static List<StripeStatistics> toStripeStatistics(List<OrcProto.StripeStatistics> types) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(types, (Function)new Function<OrcProto.StripeStatistics, StripeStatistics>(){

            public StripeStatistics apply(OrcProto.StripeStatistics type) {
                return OrcMetadataReader.toStripeStatistics(type);
            }
        }));
    }

    private static StripeStatistics toStripeStatistics(OrcProto.StripeStatistics stripeStatistics) {
        return new StripeStatistics(OrcMetadataReader.toColumnStatistics(stripeStatistics.getColStatsList()));
    }

    @Override
    public Footer readFooter(InputStream inputStream) throws IOException {
        CodedInputStream input = CodedInputStream.newInstance((InputStream)inputStream);
        OrcProto.Footer footer = OrcProto.Footer.parseFrom((CodedInputStream)input);
        return new Footer(footer.getNumberOfRows(), footer.getRowIndexStride(), OrcMetadataReader.toStripeInformation(footer.getStripesList()), OrcMetadataReader.toType(footer.getTypesList()), OrcMetadataReader.toColumnStatistics(footer.getStatisticsList()));
    }

    private static List<StripeInformation> toStripeInformation(List<OrcProto.StripeInformation> types) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(types, (Function)new Function<OrcProto.StripeInformation, StripeInformation>(){

            public StripeInformation apply(OrcProto.StripeInformation type) {
                return OrcMetadataReader.toStripeInformation(type);
            }
        }));
    }

    private static StripeInformation toStripeInformation(OrcProto.StripeInformation stripeInformation) {
        return new StripeInformation(Ints.checkedCast((long)stripeInformation.getNumberOfRows()), stripeInformation.getOffset(), stripeInformation.getIndexLength(), stripeInformation.getDataLength(), stripeInformation.getFooterLength());
    }

    @Override
    public StripeFooter readStripeFooter(List<OrcType> types, InputStream inputStream) throws IOException {
        CodedInputStream input = CodedInputStream.newInstance((InputStream)inputStream);
        OrcProto.StripeFooter stripeFooter = OrcProto.StripeFooter.parseFrom((CodedInputStream)input);
        return new StripeFooter(OrcMetadataReader.toStream(stripeFooter.getStreamsList()), OrcMetadataReader.toColumnEncoding(stripeFooter.getColumnsList()));
    }

    private static Stream toStream(OrcProto.Stream stream) {
        return new Stream(stream.getColumn(), OrcMetadataReader.toStreamKind(stream.getKind()), Ints.checkedCast((long)stream.getLength()), true);
    }

    private static List<Stream> toStream(List<OrcProto.Stream> streams) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(streams, (Function)new Function<OrcProto.Stream, Stream>(){

            public Stream apply(OrcProto.Stream stream) {
                return OrcMetadataReader.toStream(stream);
            }
        }));
    }

    private static ColumnEncoding toColumnEncoding(OrcProto.ColumnEncoding columnEncoding) {
        return new ColumnEncoding(OrcMetadataReader.toColumnEncodingKind(columnEncoding.getKind()), columnEncoding.getDictionarySize());
    }

    private static List<ColumnEncoding> toColumnEncoding(List<OrcProto.ColumnEncoding> columnEncodings) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(columnEncodings, (Function)new Function<OrcProto.ColumnEncoding, ColumnEncoding>(){

            public ColumnEncoding apply(OrcProto.ColumnEncoding columnEncoding) {
                return OrcMetadataReader.toColumnEncoding(columnEncoding);
            }
        }));
    }

    @Override
    public List<RowGroupIndex> readRowIndexes(InputStream inputStream) throws IOException {
        CodedInputStream input = CodedInputStream.newInstance((InputStream)inputStream);
        OrcProto.RowIndex rowIndex = OrcProto.RowIndex.parseFrom((CodedInputStream)input);
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)rowIndex.getEntryList(), (Function)new Function<OrcProto.RowIndexEntry, RowGroupIndex>(){

            public RowGroupIndex apply(OrcProto.RowIndexEntry rowIndexEntry) {
                return OrcMetadataReader.toRowGroupIndex(rowIndexEntry);
            }
        }));
    }

    private static RowGroupIndex toRowGroupIndex(OrcProto.RowIndexEntry rowIndexEntry) {
        List positionsList = rowIndexEntry.getPositionsList();
        ImmutableList.Builder positions = ImmutableList.builder();
        for (int index = 0; index < positionsList.size(); ++index) {
            long longPosition = (Long)positionsList.get(index);
            int intPosition = (int)longPosition;
            Preconditions.checkState(((long)intPosition == longPosition ? 1 : 0) != 0, (String)"Expected checkpoint position %s, to be an integer", (Object[])new Object[]{index});
            positions.add((Object)intPosition);
        }
        return new RowGroupIndex((List<Integer>)positions.build(), OrcMetadataReader.toColumnStatistics(rowIndexEntry.getStatistics()));
    }

    private static ColumnStatistics toColumnStatistics(OrcProto.ColumnStatistics statistics) {
        return new ColumnStatistics(statistics.getNumberOfValues(), OrcMetadataReader.toBooleanStatistics(statistics.getBucketStatistics()), OrcMetadataReader.toIntegerStatistics(statistics.getIntStatistics()), OrcMetadataReader.toDoubleStatistics(statistics.getDoubleStatistics()), OrcMetadataReader.toStringStatistics(statistics.getStringStatistics()), OrcMetadataReader.toDateStatistics(statistics.getDateStatistics()));
    }

    private static List<ColumnStatistics> toColumnStatistics(List<OrcProto.ColumnStatistics> columnStatistics) {
        if (columnStatistics == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Iterable)Iterables.transform(columnStatistics, (Function)new Function<OrcProto.ColumnStatistics, ColumnStatistics>(){

            public ColumnStatistics apply(OrcProto.ColumnStatistics columnStatistics) {
                return OrcMetadataReader.toColumnStatistics(columnStatistics);
            }
        }));
    }

    private static BooleanStatistics toBooleanStatistics(OrcProto.BucketStatistics bucketStatistics) {
        if (bucketStatistics.getCountCount() == 0) {
            return null;
        }
        return new BooleanStatistics(bucketStatistics.getCount(0));
    }

    private static IntegerStatistics toIntegerStatistics(OrcProto.IntegerStatistics integerStatistics) {
        if (!integerStatistics.hasMinimum() && !integerStatistics.hasMaximum()) {
            return null;
        }
        return new IntegerStatistics(integerStatistics.hasMinimum() ? Long.valueOf(integerStatistics.getMinimum()) : null, integerStatistics.hasMaximum() ? Long.valueOf(integerStatistics.getMaximum()) : null);
    }

    private static DoubleStatistics toDoubleStatistics(OrcProto.DoubleStatistics doubleStatistics) {
        if (!doubleStatistics.hasMinimum() && !doubleStatistics.hasMaximum()) {
            return null;
        }
        return new DoubleStatistics(doubleStatistics.hasMinimum() ? Double.valueOf(doubleStatistics.getMinimum()) : null, doubleStatistics.hasMaximum() ? Double.valueOf(doubleStatistics.getMaximum()) : null);
    }

    private static StringStatistics toStringStatistics(OrcProto.StringStatistics stringStatistics) {
        if (!stringStatistics.hasMinimum() && !stringStatistics.hasMaximum()) {
            return null;
        }
        return new StringStatistics(stringStatistics.hasMinimum() ? stringStatistics.getMinimum() : null, stringStatistics.hasMaximum() ? stringStatistics.getMaximum() : null);
    }

    private static DateStatistics toDateStatistics(OrcProto.DateStatistics dateStatistics) {
        if (!dateStatistics.hasMinimum() && !dateStatistics.hasMaximum()) {
            return null;
        }
        return new DateStatistics(dateStatistics.hasMinimum() ? Integer.valueOf(dateStatistics.getMinimum()) : null, dateStatistics.hasMaximum() ? Integer.valueOf(dateStatistics.getMaximum()) : null);
    }

    private static OrcType toType(OrcProto.Type type) {
        return new OrcType(OrcMetadataReader.toTypeKind(type.getKind()), type.getSubtypesList(), type.getFieldNamesList());
    }

    private static List<OrcType> toType(List<OrcProto.Type> types) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(types, (Function)new Function<OrcProto.Type, OrcType>(){

            public OrcType apply(OrcProto.Type type) {
                return OrcMetadataReader.toType(type);
            }
        }));
    }

    private static OrcType.OrcTypeKind toTypeKind(OrcProto.Type.Kind typeKind) {
        switch (typeKind) {
            case BOOLEAN: {
                return OrcType.OrcTypeKind.BOOLEAN;
            }
            case BYTE: {
                return OrcType.OrcTypeKind.BYTE;
            }
            case SHORT: {
                return OrcType.OrcTypeKind.SHORT;
            }
            case INT: {
                return OrcType.OrcTypeKind.INT;
            }
            case LONG: {
                return OrcType.OrcTypeKind.LONG;
            }
            case FLOAT: {
                return OrcType.OrcTypeKind.FLOAT;
            }
            case DOUBLE: {
                return OrcType.OrcTypeKind.DOUBLE;
            }
            case STRING: {
                return OrcType.OrcTypeKind.STRING;
            }
            case BINARY: {
                return OrcType.OrcTypeKind.BINARY;
            }
            case TIMESTAMP: {
                return OrcType.OrcTypeKind.TIMESTAMP;
            }
            case LIST: {
                return OrcType.OrcTypeKind.LIST;
            }
            case MAP: {
                return OrcType.OrcTypeKind.MAP;
            }
            case STRUCT: {
                return OrcType.OrcTypeKind.STRUCT;
            }
            case UNION: {
                return OrcType.OrcTypeKind.UNION;
            }
            case DECIMAL: {
                return OrcType.OrcTypeKind.DECIMAL;
            }
            case DATE: {
                return OrcType.OrcTypeKind.DATE;
            }
            case VARCHAR: {
                return OrcType.OrcTypeKind.VARCHAR;
            }
            case CHAR: {
                return OrcType.OrcTypeKind.CHAR;
            }
        }
        throw new IllegalStateException(typeKind + " stream type not implemented yet");
    }

    private static Stream.StreamKind toStreamKind(OrcProto.Stream.Kind streamKind) {
        switch (streamKind) {
            case PRESENT: {
                return Stream.StreamKind.PRESENT;
            }
            case DATA: {
                return Stream.StreamKind.DATA;
            }
            case LENGTH: {
                return Stream.StreamKind.LENGTH;
            }
            case DICTIONARY_DATA: {
                return Stream.StreamKind.DICTIONARY_DATA;
            }
            case DICTIONARY_COUNT: {
                return Stream.StreamKind.DICTIONARY_COUNT;
            }
            case SECONDARY: {
                return Stream.StreamKind.SECONDARY;
            }
            case ROW_INDEX: {
                return Stream.StreamKind.ROW_INDEX;
            }
        }
        throw new IllegalStateException(streamKind + " stream type not implemented yet");
    }

    private static ColumnEncoding.ColumnEncodingKind toColumnEncodingKind(OrcProto.ColumnEncoding.Kind columnEncodingKind) {
        switch (columnEncodingKind) {
            case DIRECT: {
                return ColumnEncoding.ColumnEncodingKind.DIRECT;
            }
            case DIRECT_V2: {
                return ColumnEncoding.ColumnEncodingKind.DIRECT_V2;
            }
            case DICTIONARY: {
                return ColumnEncoding.ColumnEncodingKind.DICTIONARY;
            }
            case DICTIONARY_V2: {
                return ColumnEncoding.ColumnEncodingKind.DICTIONARY_V2;
            }
        }
        throw new IllegalStateException(columnEncodingKind + " stream encoding not implemented yet");
    }

    private static CompressionKind toCompression(OrcProto.CompressionKind compression) {
        switch (compression) {
            case NONE: {
                return CompressionKind.UNCOMPRESSED;
            }
            case ZLIB: {
                return CompressionKind.ZLIB;
            }
            case SNAPPY: {
                return CompressionKind.SNAPPY;
            }
        }
        throw new IllegalStateException(compression + " compression not implemented yet");
    }
}

