/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.json;

import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.json.JsonReader;
import com.facebook.presto.orc.json.JsonReaders;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.stream.BooleanStream;
import com.facebook.presto.orc.stream.StreamSources;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.slice.DynamicSliceOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.annotation.Nullable;
import org.joda.time.DateTimeZone;

public class StructJsonReader
implements JsonReader {
    private final StreamDescriptor streamDescriptor;
    private final boolean writeStackType;
    private final boolean checkForNulls;
    private final String[] structFieldNames;
    private final JsonReader[] structFields;
    private final DynamicSliceOutput buffer;
    @Nullable
    private BooleanStream presentStream;

    public StructJsonReader(StreamDescriptor streamDescriptor, boolean writeStackType, boolean checkForNulls, DateTimeZone hiveStorageTimeZone, DateTimeZone sessionTimeZone) {
        this.streamDescriptor = (StreamDescriptor)Preconditions.checkNotNull((Object)streamDescriptor, (Object)"stream is null");
        this.writeStackType = writeStackType;
        this.checkForNulls = checkForNulls;
        List<StreamDescriptor> nestedStreams = streamDescriptor.getNestedStreams();
        this.structFieldNames = new String[nestedStreams.size()];
        this.structFields = new JsonReader[nestedStreams.size()];
        for (int i = 0; i < nestedStreams.size(); ++i) {
            StreamDescriptor nestedStream = nestedStreams.get(i);
            this.structFields[i] = JsonReaders.createJsonReader(nestedStream, true, false, hiveStorageTimeZone, sessionTimeZone);
            this.structFieldNames[i] = nestedStream.getFieldName();
        }
        this.buffer = new DynamicSliceOutput(1024);
    }

    @Override
    public void readNextValueInto(JsonGenerator generator) throws IOException {
        if (this.writeStackType) {
            this.buffer.reset();
            try (JsonGenerator jsonGenerator = new JsonFactory().createGenerator((OutputStream)this.buffer);){
                this.readNextValueIntoInternal(jsonGenerator);
            }
            byte[] byteArray = (byte[])this.buffer.getUnderlyingSlice().getBase();
            generator.writeUTF8String(byteArray, 0, this.buffer.size());
        } else {
            this.readNextValueIntoInternal(generator);
        }
    }

    public void readNextValueIntoInternal(JsonGenerator generator) throws IOException {
        if (this.presentStream != null && !this.presentStream.nextBit()) {
            generator.writeNull();
            return;
        }
        generator.writeStartObject();
        for (int structFieldIndex = 0; structFieldIndex < this.structFields.length; ++structFieldIndex) {
            generator.writeFieldName(this.structFieldNames[structFieldIndex]);
            this.structFields[structFieldIndex].readNextValueInto(generator);
        }
        generator.writeEndObject();
    }

    @Override
    public void skip(int skipSize) throws IOException {
        if (this.presentStream != null) {
            skipSize = this.presentStream.countBitsSet(skipSize);
        }
        for (JsonReader structField : this.structFields) {
            structField.skip(skipSize);
        }
    }

    @Override
    public void openStripe(StreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) throws IOException {
        this.presentStream = null;
        for (JsonReader structField : this.structFields) {
            structField.openStripe(dictionaryStreamSources, encoding);
        }
    }

    @Override
    public void openRowGroup(StreamSources dataStreamSources) throws IOException {
        if (this.checkForNulls) {
            this.presentStream = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanStream.class).openStream();
        }
        for (JsonReader structField : this.structFields) {
            structField.openRowGroup(dataStreamSources);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }
}

