/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.json;

import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.json.BooleanJsonReader;
import com.facebook.presto.orc.json.ByteJsonReader;
import com.facebook.presto.orc.json.DateJsonReader;
import com.facebook.presto.orc.json.DoubleJsonReader;
import com.facebook.presto.orc.json.FloatJsonReader;
import com.facebook.presto.orc.json.JsonMapKeyReader;
import com.facebook.presto.orc.json.JsonReader;
import com.facebook.presto.orc.json.ListJsonReader;
import com.facebook.presto.orc.json.LongJsonReader;
import com.facebook.presto.orc.json.MapJsonReader;
import com.facebook.presto.orc.json.SliceJsonReader;
import com.facebook.presto.orc.json.StructJsonReader;
import com.facebook.presto.orc.json.TimestampJsonReader;
import org.joda.time.DateTimeZone;

public final class JsonReaders {
    private JsonReaders() {
    }

    public static JsonMapKeyReader createJsonMapKeyReader(StreamDescriptor streamDescriptor, boolean writeStackType, DateTimeZone hiveStorageTimeZone, DateTimeZone sessionTimeZone) {
        switch (streamDescriptor.getStreamType()) {
            case BOOLEAN: {
                return new BooleanJsonReader(streamDescriptor);
            }
            case BYTE: {
                return new ByteJsonReader(streamDescriptor);
            }
            case SHORT: 
            case INT: 
            case LONG: {
                return new LongJsonReader(streamDescriptor);
            }
            case FLOAT: {
                return new FloatJsonReader(streamDescriptor);
            }
            case DOUBLE: {
                return new DoubleJsonReader(streamDescriptor);
            }
            case BINARY: {
                return new SliceJsonReader(streamDescriptor, true);
            }
            case STRING: {
                return new SliceJsonReader(streamDescriptor, false);
            }
            case TIMESTAMP: {
                return new TimestampJsonReader(streamDescriptor, writeStackType, hiveStorageTimeZone, sessionTimeZone);
            }
            case DATE: {
                return new DateJsonReader(streamDescriptor, writeStackType);
            }
        }
        throw new IllegalArgumentException("Unsupported map key type: " + (Object)((Object)streamDescriptor.getStreamType()));
    }

    public static JsonReader createJsonReader(StreamDescriptor streamDescriptor, boolean checkForNulls, boolean writeStackType, DateTimeZone hiveStorageTimeZone, DateTimeZone sessionTimeZone) {
        switch (streamDescriptor.getStreamType()) {
            case BOOLEAN: {
                return new BooleanJsonReader(streamDescriptor);
            }
            case BYTE: {
                return new ByteJsonReader(streamDescriptor);
            }
            case SHORT: 
            case INT: 
            case LONG: {
                return new LongJsonReader(streamDescriptor);
            }
            case FLOAT: {
                return new FloatJsonReader(streamDescriptor);
            }
            case DOUBLE: {
                return new DoubleJsonReader(streamDescriptor);
            }
            case BINARY: {
                return new SliceJsonReader(streamDescriptor, true);
            }
            case STRING: {
                return new SliceJsonReader(streamDescriptor, false);
            }
            case TIMESTAMP: {
                return new TimestampJsonReader(streamDescriptor, writeStackType, hiveStorageTimeZone, sessionTimeZone);
            }
            case DATE: {
                return new DateJsonReader(streamDescriptor, writeStackType);
            }
            case STRUCT: {
                return new StructJsonReader(streamDescriptor, writeStackType, checkForNulls, hiveStorageTimeZone, sessionTimeZone);
            }
            case LIST: {
                return new ListJsonReader(streamDescriptor, writeStackType, checkForNulls, hiveStorageTimeZone, sessionTimeZone);
            }
            case MAP: {
                return new MapJsonReader(streamDescriptor, writeStackType, checkForNulls, hiveStorageTimeZone, sessionTimeZone);
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)streamDescriptor.getStreamType()));
    }
}

