/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcPredicate;
import com.facebook.presto.orc.RowGroup;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.Stripe;
import com.facebook.presto.orc.StripeReader;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.ColumnStatistics;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.MetadataReader;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.metadata.StripeInformation;
import com.facebook.presto.orc.metadata.StripeStatistics;
import com.facebook.presto.orc.reader.StreamReader;
import com.facebook.presto.orc.reader.StreamReaders;
import com.facebook.presto.orc.stream.StreamSources;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joda.time.DateTimeZone;

public class OrcRecordReader {
    private final OrcDataSource orcDataSource;
    private final StreamReader[] streamReaders;
    private final long totalRowCount;
    private final long splitLength;
    private final Set<Integer> presentColumns;
    private long currentPosition;
    private final List<StripeInformation> stripes;
    private final StripeReader stripeReader;
    private int currentStripe = -1;
    private Iterator<RowGroup> rowGroups = ImmutableList.of().iterator();
    private long currentGroupRowCount;
    private long nextRowInGroup;

    public OrcRecordReader(Set<Integer> includedColumns, OrcPredicate predicate, long numberOfRows, List<StripeInformation> fileStripes, List<ColumnStatistics> fileStats, List<StripeStatistics> stripeStats, OrcDataSource orcDataSource, long splitOffset, long splitLength, List<OrcType> types, CompressionKind compressionKind, int bufferSize, int rowsInRowGroup, DateTimeZone hiveStorageTimeZone, DateTimeZone sessionTimeZone, MetadataReader metadataReader) throws IOException {
        Preconditions.checkNotNull(includedColumns, (Object)"includedColumns is null");
        Preconditions.checkNotNull((Object)predicate, (Object)"predicate is null");
        Preconditions.checkNotNull(fileStripes, (Object)"fileStripes is null");
        Preconditions.checkNotNull(stripeStats, (Object)"stripeStats is null");
        Preconditions.checkNotNull((Object)orcDataSource, (Object)"orcDataSource is null");
        Preconditions.checkNotNull(types, (Object)"types is null");
        Preconditions.checkNotNull((Object)((Object)compressionKind), (Object)"compressionKind is null");
        Preconditions.checkNotNull((Object)hiveStorageTimeZone, (Object)"hiveStorageTimeZone is null");
        Preconditions.checkNotNull((Object)sessionTimeZone, (Object)"sessionTimeZone is null");
        ImmutableSet.Builder presentColumns = ImmutableSet.builder();
        OrcType root = types.get(0);
        for (int includedColumn : includedColumns) {
            if (includedColumn >= root.getFieldCount()) continue;
            presentColumns.add((Object)includedColumn);
        }
        this.presentColumns = presentColumns.build();
        this.orcDataSource = orcDataSource;
        this.splitLength = splitLength;
        Preconditions.checkArgument((rowsInRowGroup > 0 ? 1 : 0) != 0, (Object)"rowsInRowGroup must be greater than zero");
        long totalRowCount = 0L;
        ImmutableList.Builder stripes = ImmutableList.builder();
        if (predicate.matches(numberOfRows, OrcRecordReader.indexByOrdinal(fileStats))) {
            for (int stripeIndex = 0; stripeIndex < fileStripes.size(); ++stripeIndex) {
                StripeInformation stripe = fileStripes.get(stripeIndex);
                if (!OrcRecordReader.splitContainsStripe(splitOffset, splitLength, stripe) || !OrcRecordReader.isStripeIncluded(stripe, stripeStats, predicate, stripeIndex)) continue;
                stripes.add((Object)stripe);
                totalRowCount += (long)stripe.getNumberOfRows();
            }
        }
        this.totalRowCount = totalRowCount;
        this.stripes = stripes.build();
        this.stripeReader = new StripeReader(orcDataSource, compressionKind, types, bufferSize, this.presentColumns, rowsInRowGroup, predicate, metadataReader);
        this.streamReaders = OrcRecordReader.createStreamReaders(orcDataSource, types, hiveStorageTimeZone, sessionTimeZone, this.presentColumns);
    }

    private static boolean splitContainsStripe(long splitOffset, long splitLength, StripeInformation stripe) {
        long splitEndOffset = splitOffset + splitLength;
        return splitOffset <= stripe.getOffset() && stripe.getOffset() < splitEndOffset;
    }

    private static boolean isStripeIncluded(StripeInformation stripe, List<StripeStatistics> stripeStats, OrcPredicate predicate, int stripeIndex) {
        if (stripeIndex >= stripeStats.size()) {
            return true;
        }
        return predicate.matches(stripe.getNumberOfRows(), OrcRecordReader.indexByOrdinal(stripeStats.get(stripeIndex).getColumnStatistics()));
    }

    private static <T> Map<Integer, T> indexByOrdinal(List<T> elements) {
        ImmutableMap.Builder statistics = ImmutableMap.builder();
        for (int ordinal = 0; ordinal < elements.size(); ++ordinal) {
            T element = elements.get(ordinal);
            if (element == null) continue;
            statistics.put((Object)ordinal, element);
        }
        return statistics.build();
    }

    public long getPosition() {
        return this.currentPosition;
    }

    public long getTotalRowCount() {
        return this.totalRowCount;
    }

    public float getProgress() {
        return (float)this.currentPosition / (float)this.totalRowCount;
    }

    public long getSplitLength() {
        return this.splitLength;
    }

    public void close() throws IOException {
        this.orcDataSource.close();
    }

    public boolean isColumnPresent(int hiveColumnIndex) {
        return this.presentColumns.contains(hiveColumnIndex);
    }

    public int nextBatch() throws IOException {
        if (this.nextRowInGroup >= this.currentGroupRowCount && !this.advanceToNextRowGroup()) {
            return -1;
        }
        int batchSize = Ints.checkedCast((long)Math.min(1024L, this.currentGroupRowCount - this.nextRowInGroup));
        for (StreamReader column : this.streamReaders) {
            if (column == null) continue;
            column.prepareNextRead(batchSize);
        }
        this.nextRowInGroup += (long)batchSize;
        this.currentPosition += (long)batchSize;
        return batchSize;
    }

    public void readVector(int columnIndex, Object vector) throws IOException {
        this.streamReaders[columnIndex].readBatch(vector);
    }

    private boolean advanceToNextRowGroup() throws IOException {
        this.nextRowInGroup = 0L;
        while (!this.rowGroups.hasNext() && this.currentStripe < this.stripes.size()) {
            this.advanceToNextStripe();
        }
        if (!this.rowGroups.hasNext()) {
            this.currentGroupRowCount = 0L;
            return false;
        }
        RowGroup currentRowGroup = this.rowGroups.next();
        this.currentGroupRowCount = currentRowGroup.getRowCount();
        StreamSources rowGroupStreamSources = currentRowGroup.getStreamSources();
        for (StreamReader column : this.streamReaders) {
            if (column == null) continue;
            column.startRowGroup(rowGroupStreamSources);
        }
        return true;
    }

    private void advanceToNextStripe() throws IOException {
        ++this.currentStripe;
        if (this.currentStripe >= this.stripes.size()) {
            return;
        }
        StripeInformation stripeInformation = this.stripes.get(this.currentStripe);
        Stripe stripe = this.stripeReader.readStripe(stripeInformation);
        if (stripe != null) {
            StreamSources dictionaryStreamSources = stripe.getDictionaryStreamSources();
            List<ColumnEncoding> columnEncodings = stripe.getColumnEncodings();
            for (StreamReader column : this.streamReaders) {
                if (column == null) continue;
                column.startStripe(dictionaryStreamSources, columnEncodings);
            }
            this.rowGroups = stripe.getRowGroups().iterator();
        } else {
            this.rowGroups = ImmutableList.of().iterator();
        }
    }

    private static StreamReader[] createStreamReaders(OrcDataSource orcDataSource, List<OrcType> types, DateTimeZone hiveStorageTimeZone, DateTimeZone sessionTimeZone, Set<Integer> includedColumns) {
        List<StreamDescriptor> streamDescriptors = OrcRecordReader.createStreamDescriptor("", "", 0, types, orcDataSource).getNestedStreams();
        OrcType rowType = types.get(0);
        StreamReader[] streamReaders = new StreamReader[rowType.getFieldCount()];
        for (int columnId = 0; columnId < rowType.getFieldCount(); ++columnId) {
            if (!includedColumns.contains(columnId)) continue;
            StreamDescriptor streamDescriptor = streamDescriptors.get(columnId);
            streamReaders[columnId] = StreamReaders.createStreamReader(streamDescriptor, hiveStorageTimeZone, sessionTimeZone);
        }
        return streamReaders;
    }

    private static StreamDescriptor createStreamDescriptor(String parentStreamName, String fieldName, int typeId, List<OrcType> types, OrcDataSource dataSource) {
        OrcType type = types.get(typeId);
        if (!fieldName.isEmpty()) {
            parentStreamName = parentStreamName + "." + fieldName;
        }
        ImmutableList.Builder nestedStreams = ImmutableList.builder();
        if (type.getOrcTypeKind() == OrcType.OrcTypeKind.STRUCT) {
            for (int i = 0; i < type.getFieldCount(); ++i) {
                nestedStreams.add((Object)OrcRecordReader.createStreamDescriptor(parentStreamName, type.getFieldName(i), type.getFieldTypeIndex(i), types, dataSource));
            }
        } else if (type.getOrcTypeKind() == OrcType.OrcTypeKind.LIST) {
            nestedStreams.add((Object)OrcRecordReader.createStreamDescriptor(parentStreamName, "item", type.getFieldTypeIndex(0), types, dataSource));
        } else if (type.getOrcTypeKind() == OrcType.OrcTypeKind.MAP) {
            nestedStreams.add((Object)OrcRecordReader.createStreamDescriptor(parentStreamName, "key", type.getFieldTypeIndex(0), types, dataSource));
            nestedStreams.add((Object)OrcRecordReader.createStreamDescriptor(parentStreamName, "value", type.getFieldTypeIndex(1), types, dataSource));
        }
        return new StreamDescriptor(parentStreamName, typeId, fieldName, type.getOrcTypeKind(), dataSource, (List<StreamDescriptor>)nestedStreams.build());
    }
}

