/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.writer;

import com.facebook.presto.orc.DwrfStreamOrderingConfig;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.DwrfSequenceEncoding;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.proto.DwrfProto;
import com.facebook.presto.orc.stream.StreamDataOutput;
import com.facebook.presto.orc.writer.ColumnSequenceKey;
import com.facebook.presto.orc.writer.StreamLayout;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class StreamOrderingLayout
implements StreamLayout {
    private static final Comparator<StreamDataOutput> IN_GROUP_COMPARATOR = (streamDataA, streamDataB) -> {
        int nodeB;
        Stream streamA = streamDataA.getStream();
        Stream streamB = streamDataB.getStream();
        int nodeA = streamA.getColumn();
        if (nodeA != (nodeB = streamB.getColumn())) {
            return Integer.compare(nodeA, nodeB);
        }
        return Integer.compare(streamA.getStreamKind().ordinal(), streamB.getStreamKind().ordinal());
    };
    private final DwrfStreamOrderingConfig config;
    private final StreamLayout nonStreamOrderingLayout;

    public StreamOrderingLayout(DwrfStreamOrderingConfig config, StreamLayout layout) {
        this.config = Objects.requireNonNull(config, "config cannot be null");
        this.nonStreamOrderingLayout = Objects.requireNonNull(layout, "layout cannot be null");
    }

    private StreamMetadata getStreamMetadata(Map<Integer, Integer> nodeIdToColumn, Map<Integer, ColumnEncoding> nodeIdToColumnEncodings, DwrfStreamOrderingConfig config) {
        ImmutableMap.Builder keyToSequenceBuilder = ImmutableMap.builder();
        ImmutableMap.Builder sequenceToStreamsBuilder = ImmutableMap.builder();
        Map<Integer, Set<DwrfProto.KeyInfo>> columnToKeySet = config.getStreamOrdering();
        HashSet<Integer> columnsVisited = new HashSet<Integer>(columnToKeySet.size());
        for (Map.Entry<Integer, ColumnEncoding> entry : nodeIdToColumnEncodings.entrySet()) {
            int nodeId = entry.getKey();
            if (nodeId == 0) continue;
            int column = nodeIdToColumn.get(nodeId);
            if (!entry.getValue().getAdditionalSequenceEncodings().isPresent() || !columnToKeySet.containsKey(column) || columnsVisited.contains(column)) continue;
            Set<DwrfProto.KeyInfo> keysPerColumn = columnToKeySet.get(column);
            for (Map.Entry<Integer, DwrfSequenceEncoding> sequenceToEncoding : entry.getValue().getAdditionalSequenceEncodings().get().entrySet()) {
                Integer sequence = sequenceToEncoding.getKey();
                DwrfProto.KeyInfo key = sequenceToEncoding.getValue().getKey();
                if (!keysPerColumn.contains(key)) continue;
                keyToSequenceBuilder.put((Object)new ColumnKeyInfo(column, key), (Object)sequence);
                sequenceToStreamsBuilder.put((Object)new ColumnSequenceKey(column, sequence), new ArrayList());
            }
            columnsVisited.add(column);
        }
        return new StreamMetadata((Map<ColumnSequenceKey, List<StreamDataOutput>>)sequenceToStreamsBuilder.build(), (Map<ColumnKeyInfo, Integer>)keyToSequenceBuilder.build());
    }

    @Override
    public void reorder(List<StreamDataOutput> dataStreams, Map<Integer, Integer> nodeIdToColumn, Map<Integer, ColumnEncoding> nodeIdToColumnEncodings) {
        int column;
        ArrayList<StreamDataOutput> nonReorderStreams = new ArrayList<StreamDataOutput>();
        StreamMetadata metadata = this.getStreamMetadata(nodeIdToColumn, nodeIdToColumnEncodings, this.config);
        Map sequenceToStreams = metadata.sequenceToStreams;
        for (StreamDataOutput dataOutput : dataStreams) {
            int nodeId = dataOutput.getStream().getColumn();
            int sequence = dataOutput.getStream().getSequence();
            column = nodeIdToColumn.get(nodeId);
            if (sequence > 0) {
                List streams = (List)sequenceToStreams.get(new ColumnSequenceKey(column, sequence));
                if (streams == null) {
                    nonReorderStreams.add(dataOutput);
                    continue;
                }
                streams.add(dataOutput);
                continue;
            }
            nonReorderStreams.add(dataOutput);
        }
        ArrayList orderedStreams = new ArrayList();
        Map keyToSequence = metadata.keyToSequence;
        for (Map.Entry<Integer, Set<DwrfProto.KeyInfo>> columnToKeys : this.config.getStreamOrdering().entrySet()) {
            column = columnToKeys.getKey();
            for (DwrfProto.KeyInfo key : columnToKeys.getValue()) {
                ColumnKeyInfo columnKeyInfo = new ColumnKeyInfo(column, key);
                Integer sequence = (Integer)keyToSequence.get(columnKeyInfo);
                if (sequence == null) continue;
                ColumnSequenceKey columnSequenceInfo = new ColumnSequenceKey(column, sequence);
                List groupedDataStreams = (List)sequenceToStreams.get(columnSequenceInfo);
                Preconditions.checkState((groupedDataStreams != null ? 1 : 0) != 0, (Object)"list of streams for a sequence cannot be null");
                Preconditions.checkState((groupedDataStreams.size() > 0 ? 1 : 0) != 0, (Object)"There should be at least one stream for a sequence");
                groupedDataStreams.sort(IN_GROUP_COMPARATOR);
                orderedStreams.addAll(groupedDataStreams);
            }
        }
        this.nonStreamOrderingLayout.reorder(nonReorderStreams, nodeIdToColumn, nodeIdToColumnEncodings);
        Preconditions.checkState((orderedStreams.size() + nonReorderStreams.size() == dataStreams.size() ? 1 : 0) != 0, (String)"Number of ordered + non ordered streams should be equal to total number of data streams orderedStreams: %s, nonReorderStreams: %s, dataStreams: %s", (Object)orderedStreams.size(), (Object)nonReorderStreams.size(), (Object)dataStreams.size());
        dataStreams.clear();
        dataStreams.addAll(orderedStreams);
        dataStreams.addAll(nonReorderStreams);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("config", (Object)this.config).add("nonStreamOrderingLayout", (Object)this.nonStreamOrderingLayout).toString();
    }

    private static class ColumnKeyInfo {
        private final int column;
        private final DwrfProto.KeyInfo key;

        public ColumnKeyInfo(int column, DwrfProto.KeyInfo key) {
            this.column = column;
            this.key = Objects.requireNonNull(key, "key cannot be null");
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ColumnKeyInfo)) {
                return false;
            }
            ColumnKeyInfo input = (ColumnKeyInfo)obj;
            return this.column == input.column && this.key.equals((Object)input.key);
        }

        public int hashCode() {
            return Objects.hash(this.column, this.key);
        }
    }

    private static class StreamMetadata {
        private final Map<ColumnSequenceKey, List<StreamDataOutput>> sequenceToStreams;
        private final Map<ColumnKeyInfo, Integer> keyToSequence;

        public StreamMetadata(Map<ColumnSequenceKey, List<StreamDataOutput>> sequenceToStreams, Map<ColumnKeyInfo, Integer> keyToSequence) {
            this.sequenceToStreams = Objects.requireNonNull(sequenceToStreams, "sequenceToStreams cannot be null");
            this.keyToSequence = Objects.requireNonNull(keyToSequence, "keyToSequence cannot be null");
        }
    }
}

