/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.writer;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.orc.array.IntBigArray;
import com.facebook.presto.orc.writer.SegmentedSliceBlockBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import it.unimi.dsi.fastutil.HashCommon;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class SliceDictionaryBuilder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SliceDictionaryBuilder.class).instanceSize();
    private static final float FILL_RATIO = 0.75f;
    private static final int EMPTY_SLOT = -1;
    private static final int EXPECTED_BYTES_PER_ENTRY = 32;
    private final IntBigArray slicePositionByHash = new IntBigArray();
    private final SegmentedSliceBlockBuilder segmentedSliceBuilder;
    private int maxFill;
    private int hashMask;

    public SliceDictionaryBuilder(int expectedSize) {
        Preconditions.checkArgument((expectedSize >= 0 ? 1 : 0) != 0, (Object)"expectedSize must not be negative");
        int expectedEntries = Math.min(expectedSize, 32768);
        this.segmentedSliceBuilder = new SegmentedSliceBlockBuilder(expectedEntries, expectedEntries * 32);
        int hashSize = HashCommon.arraySize((int)expectedSize, (float)0.75f);
        this.maxFill = SliceDictionaryBuilder.calculateMaxFill(hashSize);
        this.hashMask = hashSize - 1;
        this.slicePositionByHash.ensureCapacity(hashSize);
        this.slicePositionByHash.fill(-1);
    }

    public long getSizeInBytes() {
        return this.segmentedSliceBuilder.getSizeInBytes();
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.segmentedSliceBuilder.getRetainedSizeInBytes() + this.slicePositionByHash.sizeOf();
    }

    public int compareIndex(int left, int right) {
        return this.segmentedSliceBuilder.compareTo(left, right);
    }

    public int getSliceLength(int position) {
        return this.segmentedSliceBuilder.getSliceLength(position);
    }

    @VisibleForTesting
    Slice getSlice(int position, int length) {
        return this.segmentedSliceBuilder.getSlice(position, 0, length);
    }

    public Block getBlock() {
        return this.segmentedSliceBuilder;
    }

    @VisibleForTesting
    Slice getRawSlice(int position) {
        return this.segmentedSliceBuilder.getRawSlice(position);
    }

    @VisibleForTesting
    int getRawSliceOffset(int position) {
        return this.segmentedSliceBuilder.getPositionOffset(position);
    }

    public int getEntryCount() {
        return this.segmentedSliceBuilder.getPositionCount();
    }

    public int putIfAbsent(Block block, int position) {
        Objects.requireNonNull(block, "block must not be null");
        Preconditions.checkArgument((!block.isNull(position) ? 1 : 0) != 0, (Object)"position is null");
        int length = block.getSliceLength(position);
        long hashPosition = this.getMaskedHash(block.hash(position, 0, length));
        int slicePosition;
        while ((slicePosition = this.slicePositionByHash.get(hashPosition)) != -1) {
            if (this.segmentedSliceBuilder.equals(slicePosition, block, position, length)) {
                return slicePosition;
            }
            hashPosition = this.getMaskedHash(hashPosition + 1L);
        }
        return this.addNewElement(hashPosition, block, position);
    }

    private long getRehashPositionOfElement(int position) {
        long hashPosition = this.getMaskedHash(this.segmentedSliceBuilder.hash(position));
        while (this.slicePositionByHash.get(hashPosition) != -1) {
            hashPosition = this.getMaskedHash(hashPosition + 1L);
        }
        return hashPosition;
    }

    private int addNewElement(long hashPosition, Block block, int position) {
        Preconditions.checkArgument((!block.isNull(position) ? 1 : 0) != 0, (Object)"position is null");
        block.writeBytesTo(position, 0, block.getSliceLength(position), (BlockBuilder)this.segmentedSliceBuilder);
        this.segmentedSliceBuilder.closeEntry();
        int newElementPositionInBlock = this.segmentedSliceBuilder.getPositionCount() - 1;
        this.slicePositionByHash.set(hashPosition, newElementPositionInBlock);
        if (this.segmentedSliceBuilder.getPositionCount() >= this.maxFill) {
            this.rehash(this.maxFill * 2);
        }
        return newElementPositionInBlock;
    }

    private void rehash(int size) {
        int newHashSize = HashCommon.arraySize((int)(size + 1), (float)0.75f);
        this.hashMask = newHashSize - 1;
        this.maxFill = SliceDictionaryBuilder.calculateMaxFill(newHashSize);
        this.slicePositionByHash.ensureCapacity(newHashSize);
        this.slicePositionByHash.fill(-1);
        for (int slicePosition = 0; slicePosition < this.segmentedSliceBuilder.getPositionCount(); ++slicePosition) {
            this.slicePositionByHash.set(this.getRehashPositionOfElement(slicePosition), slicePosition);
        }
    }

    private static int calculateMaxFill(int hashSize) {
        int maxFill = (int)Math.ceil((float)hashSize * 0.75f);
        if (maxFill == hashSize) {
            --maxFill;
        }
        return maxFill;
    }

    private long getMaskedHash(long rawHash) {
        return rawHash & (long)this.hashMask;
    }
}

