/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.writer;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.orc.ColumnWriterOptions;
import com.facebook.presto.orc.DwrfDataEncryptor;
import com.facebook.presto.orc.DwrfEncryptionInfo;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.metadata.MetadataWriter;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.metadata.statistics.BinaryStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.DateStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.IntegerStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.StatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.StatisticsBuilders;
import com.facebook.presto.orc.metadata.statistics.StringStatisticsBuilder;
import com.facebook.presto.orc.writer.BooleanColumnWriter;
import com.facebook.presto.orc.writer.ByteColumnWriter;
import com.facebook.presto.orc.writer.ColumnWriter;
import com.facebook.presto.orc.writer.DecimalColumnWriter;
import com.facebook.presto.orc.writer.DoubleColumnWriter;
import com.facebook.presto.orc.writer.FloatColumnWriter;
import com.facebook.presto.orc.writer.ListColumnWriter;
import com.facebook.presto.orc.writer.LongColumnWriter;
import com.facebook.presto.orc.writer.LongDictionaryColumnWriter;
import com.facebook.presto.orc.writer.MapColumnWriter;
import com.facebook.presto.orc.writer.MapFlatColumnWriter;
import com.facebook.presto.orc.writer.SliceDictionaryColumnWriter;
import com.facebook.presto.orc.writer.SliceDirectColumnWriter;
import com.facebook.presto.orc.writer.StructColumnWriter;
import com.facebook.presto.orc.writer.TimestampColumnWriter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import org.joda.time.DateTimeZone;

public final class ColumnWriters {
    private ColumnWriters() {
    }

    public static ColumnWriter createColumnWriter(int nodeIndex, int sequence, List<OrcType> orcTypes, Type type, ColumnWriterOptions columnWriterOptions, OrcEncoding orcEncoding, DateTimeZone hiveStorageTimeZone, DwrfEncryptionInfo dwrfEncryptors, MetadataWriter metadataWriter) {
        Objects.requireNonNull(type, "type is null");
        OrcType orcType = orcTypes.get(nodeIndex);
        Optional<DwrfDataEncryptor> dwrfEncryptor = dwrfEncryptors.getEncryptorByNodeId(nodeIndex);
        switch (orcType.getOrcTypeKind()) {
            case BOOLEAN: {
                return new BooleanColumnWriter(nodeIndex, sequence, type, columnWriterOptions, dwrfEncryptor, metadataWriter);
            }
            case FLOAT: {
                return new FloatColumnWriter(nodeIndex, sequence, type, columnWriterOptions, dwrfEncryptor, metadataWriter);
            }
            case DOUBLE: {
                return new DoubleColumnWriter(nodeIndex, sequence, type, columnWriterOptions, dwrfEncryptor, metadataWriter);
            }
            case BYTE: {
                return new ByteColumnWriter(nodeIndex, sequence, type, columnWriterOptions, dwrfEncryptor, metadataWriter);
            }
            case DATE: {
                Preconditions.checkArgument((orcEncoding != OrcEncoding.DWRF ? 1 : 0) != 0, (String)"DWRF does not support %s type", (Object)type);
                return new LongColumnWriter(nodeIndex, 0, type, columnWriterOptions, dwrfEncryptor, orcEncoding, DateStatisticsBuilder::new, metadataWriter);
            }
            case SHORT: {
                return new LongColumnWriter(nodeIndex, sequence, type, columnWriterOptions, dwrfEncryptor, orcEncoding, IntegerStatisticsBuilder::new, metadataWriter);
            }
            case INT: 
            case LONG: {
                if (columnWriterOptions.isIntegerDictionaryEncodingEnabled() && orcEncoding == OrcEncoding.DWRF) {
                    return new LongDictionaryColumnWriter(nodeIndex, sequence, type, columnWriterOptions, dwrfEncryptor, orcEncoding, metadataWriter);
                }
                return new LongColumnWriter(nodeIndex, sequence, type, columnWriterOptions, dwrfEncryptor, orcEncoding, IntegerStatisticsBuilder::new, metadataWriter);
            }
            case DECIMAL: {
                Preconditions.checkArgument((orcEncoding != OrcEncoding.DWRF ? 1 : 0) != 0, (String)"DWRF does not support %s type", (Object)type);
                return new DecimalColumnWriter(nodeIndex, type, columnWriterOptions, orcEncoding, metadataWriter);
            }
            case TIMESTAMP: 
            case TIMESTAMP_MICROSECONDS: {
                return new TimestampColumnWriter(nodeIndex, sequence, type, columnWriterOptions, dwrfEncryptor, orcEncoding, hiveStorageTimeZone, metadataWriter);
            }
            case BINARY: {
                return new SliceDirectColumnWriter(nodeIndex, sequence, type, columnWriterOptions, dwrfEncryptor, orcEncoding, BinaryStatisticsBuilder::new, metadataWriter);
            }
            case CHAR: {
                Preconditions.checkArgument((orcEncoding != OrcEncoding.DWRF ? 1 : 0) != 0, (String)"DWRF does not support %s type", (Object)type);
            }
            case VARCHAR: 
            case STRING: {
                if (columnWriterOptions.isStringDictionaryEncodingEnabled()) {
                    return new SliceDictionaryColumnWriter(nodeIndex, sequence, type, columnWriterOptions, dwrfEncryptor, orcEncoding, metadataWriter);
                }
                int stringStatisticsLimit = columnWriterOptions.getStringStatisticsLimit();
                return new SliceDirectColumnWriter(nodeIndex, sequence, type, columnWriterOptions, dwrfEncryptor, orcEncoding, () -> new StringStatisticsBuilder(stringStatisticsLimit), metadataWriter);
            }
            case LIST: {
                Type fieldType = (Type)type.getTypeParameters().get(0);
                ColumnWriter elementWriter = ColumnWriters.createColumnWriter(orcType.getFieldTypeIndex(0), sequence, orcTypes, fieldType, columnWriterOptions, orcEncoding, hiveStorageTimeZone, dwrfEncryptors, metadataWriter);
                return new ListColumnWriter(nodeIndex, sequence, columnWriterOptions, dwrfEncryptor, orcEncoding, elementWriter, metadataWriter);
            }
            case MAP: {
                if (columnWriterOptions.getFlattenedNodes().contains(nodeIndex)) {
                    Preconditions.checkArgument((orcEncoding == OrcEncoding.DWRF ? 1 : 0) != 0, (String)"%s does not support flat maps", (Object)((Object)orcEncoding));
                    Type valueType = (Type)type.getTypeParameters().get(1);
                    OrcType keyOrcType = orcTypes.get(orcType.getFieldTypeIndex(0));
                    Supplier<StatisticsBuilder> keyStatisticsBuilderSupplier = StatisticsBuilders.createStatisticsBuilderSupplier(keyOrcType, columnWriterOptions);
                    ColumnWriterOptions valueWriterColumnWriterOptions = columnWriterOptions.copyWithDisabledDictionaryEncoding();
                    int valueNodeIndex = orcType.getFieldTypeIndex(1);
                    Supplier<Map<Integer, ColumnStatistics>> emptyColumnStatisticsSupplier = () -> StatisticsBuilders.createEmptyColumnStatistics(orcTypes, valueNodeIndex, columnWriterOptions);
                    IntFunction<ColumnWriter> valueWriterSupplier = valueSequence -> ColumnWriters.createColumnWriter(valueNodeIndex, valueSequence, orcTypes, valueType, valueWriterColumnWriterOptions, orcEncoding, hiveStorageTimeZone, dwrfEncryptors, metadataWriter);
                    return new MapFlatColumnWriter(nodeIndex, orcType.getFieldTypeIndex(0), valueNodeIndex, (Type)type.getTypeParameters().get(0), valueType, keyStatisticsBuilderSupplier, columnWriterOptions, dwrfEncryptor, metadataWriter, valueWriterSupplier, emptyColumnStatisticsSupplier);
                }
                ColumnWriter keyWriter = ColumnWriters.createColumnWriter(orcType.getFieldTypeIndex(0), sequence, orcTypes, (Type)type.getTypeParameters().get(0), columnWriterOptions, orcEncoding, hiveStorageTimeZone, dwrfEncryptors, metadataWriter);
                ColumnWriter valueWriter = ColumnWriters.createColumnWriter(orcType.getFieldTypeIndex(1), sequence, orcTypes, (Type)type.getTypeParameters().get(1), columnWriterOptions, orcEncoding, hiveStorageTimeZone, dwrfEncryptors, metadataWriter);
                return new MapColumnWriter(nodeIndex, sequence, columnWriterOptions, dwrfEncryptor, orcEncoding, keyWriter, valueWriter, metadataWriter);
            }
            case STRUCT: {
                ImmutableList.Builder fieldWriters = ImmutableList.builder();
                for (int fieldId = 0; fieldId < orcType.getFieldCount(); ++fieldId) {
                    int childNodeIndex = orcType.getFieldTypeIndex(fieldId);
                    Type fieldType = (Type)type.getTypeParameters().get(fieldId);
                    fieldWriters.add((Object)ColumnWriters.createColumnWriter(childNodeIndex, sequence, orcTypes, fieldType, columnWriterOptions, orcEncoding, hiveStorageTimeZone, dwrfEncryptors, metadataWriter));
                }
                return new StructColumnWriter(nodeIndex, sequence, columnWriterOptions, dwrfEncryptor, (List<ColumnWriter>)fieldWriters.build(), metadataWriter);
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }
}

