/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.writer;

import com.facebook.presto.orc.checkpoint.BooleanStreamCheckpoint;
import com.facebook.presto.orc.checkpoint.StreamCheckpoint;
import com.facebook.presto.orc.metadata.RowGroupIndex;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.stream.PresentOutputStream;
import com.facebook.presto.orc.stream.ValueOutputStream;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ColumnWriterUtils {
    private ColumnWriterUtils() {
    }

    @SafeVarargs
    public static List<RowGroupIndex> buildRowGroupIndexes(boolean compressed, List<ColumnStatistics> rowGroupColumnStatistics, Optional<List<? extends StreamCheckpoint>> prependCheckpoints, PresentOutputStream presentStream, ValueOutputStream<? extends StreamCheckpoint> ... dataStreams) {
        ImmutableList.Builder rowGroupIndexes = ImmutableList.builder();
        Optional<List<BooleanStreamCheckpoint>> presentCheckpoints = presentStream.getCheckpoints();
        List dataCheckpoints = Arrays.stream(dataStreams).map(ValueOutputStream::getCheckpoints).collect(Collectors.toList());
        ArrayList<Integer> positions = new ArrayList<Integer>();
        for (int i = 0; i < rowGroupColumnStatistics.size(); ++i) {
            int groupId = i;
            Optional<StreamCheckpoint> prependCheckpoint = prependCheckpoints.map(checkpoints -> (StreamCheckpoint)checkpoints.get(groupId));
            Optional<StreamCheckpoint> presentCheckpoint = presentCheckpoints.map(checkpoints -> (StreamCheckpoint)checkpoints.get(groupId));
            prependCheckpoint.ifPresent(checkpoint -> positions.addAll(checkpoint.toPositionList(compressed)));
            presentCheckpoint.ifPresent(checkpoint -> positions.addAll(checkpoint.toPositionList(compressed)));
            for (List dataCheckpoint : dataCheckpoints) {
                StreamCheckpoint streamCheckpoint = (StreamCheckpoint)dataCheckpoint.get(groupId);
                positions.addAll(streamCheckpoint.toPositionList(compressed));
            }
            ColumnStatistics columnStatistics = rowGroupColumnStatistics.get(groupId);
            rowGroupIndexes.add((Object)new RowGroupIndex(Ints.toArray(positions), columnStatistics));
            positions.clear();
        }
        return rowGroupIndexes.build();
    }
}

