/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.StreamId;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.stream.BooleanInputStream;
import com.facebook.presto.orc.stream.ByteArrayInputStream;
import com.facebook.presto.orc.stream.ByteInputStream;
import com.facebook.presto.orc.stream.DecimalInputStream;
import com.facebook.presto.orc.stream.DoubleInputStream;
import com.facebook.presto.orc.stream.FloatInputStream;
import com.facebook.presto.orc.stream.LongInputStreamDwrf;
import com.facebook.presto.orc.stream.LongInputStreamV1;
import com.facebook.presto.orc.stream.LongInputStreamV2;
import com.facebook.presto.orc.stream.OrcInputStream;
import com.facebook.presto.orc.stream.RowGroupDictionaryLengthInputStream;
import com.facebook.presto.orc.stream.ValueInputStream;

public final class ValueStreams {
    private ValueStreams() {
    }

    public static ValueInputStream<?> createValueStreams(StreamId streamId, OrcInputStream inputStream, OrcType.OrcTypeKind type, ColumnEncoding.ColumnEncodingKind encoding, boolean usesVInt) {
        if (streamId.getStreamKind() == Stream.StreamKind.PRESENT || streamId.getStreamKind() == Stream.StreamKind.IN_MAP) {
            return new BooleanInputStream(inputStream);
        }
        if (!(encoding != ColumnEncoding.ColumnEncodingKind.DICTIONARY && encoding != ColumnEncoding.ColumnEncodingKind.DICTIONARY_V2 || streamId.getStreamKind() != Stream.StreamKind.LENGTH && streamId.getStreamKind() != Stream.StreamKind.DATA)) {
            return ValueStreams.createLongStream(inputStream, encoding, OrcType.OrcTypeKind.INT, false, usesVInt);
        }
        if (streamId.getStreamKind() == Stream.StreamKind.DATA) {
            switch (type) {
                case BOOLEAN: {
                    return new BooleanInputStream(inputStream);
                }
                case BYTE: {
                    return new ByteInputStream(inputStream);
                }
                case SHORT: 
                case INT: 
                case LONG: 
                case DATE: 
                case TIMESTAMP: 
                case TIMESTAMP_MICROSECONDS: {
                    return ValueStreams.createLongStream(inputStream, encoding, type, true, usesVInt);
                }
                case FLOAT: {
                    return new FloatInputStream(inputStream);
                }
                case DOUBLE: {
                    return new DoubleInputStream(inputStream);
                }
                case STRING: 
                case VARCHAR: 
                case CHAR: 
                case BINARY: {
                    return new ByteArrayInputStream(inputStream);
                }
                case DECIMAL: {
                    return new DecimalInputStream(inputStream);
                }
            }
        }
        if (streamId.getStreamKind() == Stream.StreamKind.LENGTH) {
            switch (type) {
                case STRING: 
                case VARCHAR: 
                case CHAR: 
                case BINARY: 
                case MAP: 
                case LIST: {
                    return ValueStreams.createLongStream(inputStream, encoding, type, false, usesVInt);
                }
            }
        }
        if (streamId.getStreamKind() == Stream.StreamKind.ROW_GROUP_DICTIONARY_LENGTH) {
            switch (type) {
                case STRING: 
                case VARCHAR: 
                case CHAR: 
                case BINARY: {
                    return new RowGroupDictionaryLengthInputStream(inputStream, false);
                }
            }
        }
        if (streamId.getStreamKind() == Stream.StreamKind.ROW_GROUP_DICTIONARY) {
            switch (type) {
                case STRING: 
                case VARCHAR: 
                case CHAR: 
                case BINARY: {
                    return new ByteArrayInputStream(inputStream);
                }
            }
        }
        if (streamId.getStreamKind() == Stream.StreamKind.IN_DICTIONARY) {
            return new BooleanInputStream(inputStream);
        }
        if ((type == OrcType.OrcTypeKind.TIMESTAMP || type == OrcType.OrcTypeKind.TIMESTAMP_MICROSECONDS) && streamId.getStreamKind() == Stream.StreamKind.SECONDARY) {
            return ValueStreams.createLongStream(inputStream, encoding, type, false, usesVInt);
        }
        if (type == OrcType.OrcTypeKind.DECIMAL && streamId.getStreamKind() == Stream.StreamKind.SECONDARY) {
            return ValueStreams.createLongStream(inputStream, encoding, type, true, usesVInt);
        }
        if (streamId.getStreamKind() == Stream.StreamKind.DICTIONARY_DATA) {
            switch (type) {
                case SHORT: 
                case INT: 
                case LONG: {
                    return ValueStreams.createLongStream(inputStream, ColumnEncoding.ColumnEncodingKind.DWRF_DIRECT, OrcType.OrcTypeKind.INT, true, usesVInt);
                }
                case STRING: 
                case VARCHAR: 
                case CHAR: 
                case BINARY: {
                    return new ByteArrayInputStream(inputStream);
                }
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported column type %s for stream %s with encoding %s", new Object[]{type, streamId, encoding}));
    }

    private static ValueInputStream<?> createLongStream(OrcInputStream inputStream, ColumnEncoding.ColumnEncodingKind encoding, OrcType.OrcTypeKind type, boolean signed, boolean usesVInt) {
        if (encoding == ColumnEncoding.ColumnEncodingKind.DIRECT_V2 || encoding == ColumnEncoding.ColumnEncodingKind.DICTIONARY_V2) {
            return new LongInputStreamV2(inputStream, signed, false);
        }
        if (encoding == ColumnEncoding.ColumnEncodingKind.DIRECT || encoding == ColumnEncoding.ColumnEncodingKind.DICTIONARY) {
            return new LongInputStreamV1(inputStream, signed);
        }
        if (encoding == ColumnEncoding.ColumnEncodingKind.DWRF_DIRECT) {
            return new LongInputStreamDwrf(inputStream, type, signed, usesVInt);
        }
        throw new IllegalArgumentException("Unsupported encoding for long stream: " + (Object)((Object)encoding));
    }
}

