/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.orc.checkpoint.DoubleStreamCheckpoint;
import com.facebook.presto.orc.stream.OrcInputStream;
import com.facebook.presto.orc.stream.ValueInputStream;
import java.io.IOException;

public class DoubleInputStream
implements ValueInputStream<DoubleStreamCheckpoint> {
    private final OrcInputStream input;

    public DoubleInputStream(OrcInputStream input) {
        this.input = input;
    }

    @Override
    public Class<DoubleStreamCheckpoint> getCheckpointType() {
        return DoubleStreamCheckpoint.class;
    }

    @Override
    public void seekToCheckpoint(DoubleStreamCheckpoint checkpoint) throws IOException {
        this.input.seekToCheckpoint(checkpoint.getInputStreamCheckpoint());
    }

    @Override
    public void skip(long items) throws IOException {
        long length = items * 8L;
        this.input.skipFully(length);
    }

    public double next() throws IOException {
        return this.input.readDouble();
    }

    public void nextVector(Type type, int items, BlockBuilder builder) throws IOException {
        for (int i = 0; i < items; ++i) {
            type.writeDouble(builder, this.next());
        }
    }
}

