/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.array.Arrays;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockLease;
import com.facebook.presto.common.block.ClosingBlockLease;
import com.facebook.presto.common.block.RowBlock;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.predicate.TupleDomainFilter;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcLocalMemoryContext;
import com.facebook.presto.orc.OrcRecordReaderOptions;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.Stripe;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.reader.SelectiveStreamReader;
import com.facebook.presto.orc.reader.SelectiveStreamReaders;
import com.facebook.presto.orc.reader.StreamReader;
import com.facebook.presto.orc.stream.BooleanInputStream;
import com.facebook.presto.orc.stream.InputStreamSource;
import com.facebook.presto.orc.stream.InputStreamSources;
import com.facebook.presto.orc.stream.MissingInputStreamSource;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import io.airlift.slice.SizeOf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.joda.time.DateTimeZone;
import org.openjdk.jol.info.ClassLayout;

public class StructSelectiveStreamReader
implements SelectiveStreamReader {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(StructSelectiveStreamReader.class).instanceSize();
    private final StreamDescriptor streamDescriptor;
    private final boolean nullsAllowed;
    private final boolean nonNullsAllowed;
    private final boolean outputRequired;
    @Nullable
    private final Type outputType;
    private final Map<String, SelectiveStreamReader> nestedReaders;
    private final SelectiveStreamReader[] orderedNestedReaders;
    private final boolean missingFieldFilterIsFalse;
    private final OrcLocalMemoryContext systemMemoryContext;
    private int readOffset;
    private int nestedReadOffset;
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.getBooleanMissingStreamSource();
    @Nullable
    private BooleanInputStream presentStream;
    private boolean rowGroupOpen;
    private boolean[] nulls;
    private int[] outputPositions;
    private int outputPositionCount;
    private boolean allNulls;
    private int[] nestedPositions;
    private int[] nestedOutputPositions;
    private int nestedOutputPositionCount;
    private boolean valuesInUse;

    public StructSelectiveStreamReader(StreamDescriptor streamDescriptor, Map<Subfield, TupleDomainFilter> filters, List<Subfield> requiredSubfields, Optional<Type> outputType, DateTimeZone hiveStorageTimeZone, OrcRecordReaderOptions options, OrcAggregatedMemoryContext systemMemoryContext, boolean isLowMemory) {
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "streamDescriptor is null");
        this.systemMemoryContext = Objects.requireNonNull(systemMemoryContext, "systemMemoryContext is null").newOrcLocalMemoryContext(StructSelectiveStreamReader.class.getSimpleName());
        this.outputRequired = Objects.requireNonNull(outputType, "outputType is null").isPresent();
        this.outputType = outputType.orElse(null);
        if (filters.isEmpty()) {
            this.nullsAllowed = true;
            this.nonNullsAllowed = true;
        } else {
            Optional<TupleDomainFilter> topLevelFilter = StructSelectiveStreamReader.getTopLevelFilter(filters);
            if (topLevelFilter.isPresent()) {
                this.nullsAllowed = topLevelFilter.get() == TupleDomainFilter.IS_NULL;
                this.nonNullsAllowed = !this.nullsAllowed;
            } else {
                this.nullsAllowed = filters.values().stream().allMatch(TupleDomainFilter::testNull);
                this.nonNullsAllowed = true;
            }
        }
        ImmutableMap nestedStreams = Maps.uniqueIndex(streamDescriptor.getNestedStreams(), stream -> stream.getFieldName().toLowerCase(Locale.ENGLISH));
        Optional<Map<String, List<Subfield>>> requiredFields = StructSelectiveStreamReader.getRequiredFields(requiredSubfields);
        Set fieldsWithFilters = (Set)filters.keySet().stream().map(Subfield::getPath).filter(path -> path.size() > 0).map(path -> (Subfield.PathElement)path.get(0)).filter(Subfield.NestedField.class::isInstance).map(Subfield.NestedField.class::cast).map(Subfield.NestedField::getName).collect(ImmutableSet.toImmutableSet());
        if (!this.checkMissingFieldFilters(nestedStreams.values(), filters)) {
            this.missingFieldFilterIsFalse = true;
            this.nestedReaders = ImmutableMap.of();
            this.orderedNestedReaders = new SelectiveStreamReader[0];
        } else if (this.outputRequired || !fieldsWithFilters.isEmpty()) {
            ImmutableMap.Builder nestedReaders = ImmutableMap.builder();
            ImmutableMap nestedTypes = outputType.isPresent() ? (Map)((RowType)this.outputType).getFields().stream().collect(ImmutableMap.toImmutableMap(field -> ((String)field.getName().orElseThrow(() -> new IllegalArgumentException("ROW type does not have field names declared: " + this.outputType))).toLowerCase(Locale.ENGLISH), Function.identity())) : ImmutableMap.of();
            Set structFields = outputType.isPresent() ? nestedTypes.keySet() : nestedStreams.keySet();
            for (String fieldName : structFields) {
                StreamDescriptor nestedStream = (StreamDescriptor)nestedStreams.get(fieldName);
                boolean requiredField = requiredFields.map(names -> names.containsKey(fieldName)).orElse(this.outputRequired);
                Optional<Type> fieldOutputType = Optional.ofNullable((RowType.Field)nestedTypes.get(fieldName)).map(RowType.Field::getType);
                if (nestedStream == null) {
                    Verify.verify((boolean)fieldOutputType.isPresent(), (String)("Missing output type for subfield " + fieldName), (Object[])new Object[0]);
                    nestedReaders.put((Object)fieldName, (Object)new MissingFieldStreamReader(fieldOutputType.get()));
                    continue;
                }
                if (requiredField || fieldsWithFilters.contains(fieldName)) {
                    Map nestedFilters = (Map)filters.entrySet().stream().filter(entry -> ((Subfield)entry.getKey()).getPath().size() > 0).filter(entry -> ((Subfield.NestedField)((Subfield)entry.getKey()).getPath().get(0)).getName().equalsIgnoreCase(fieldName)).collect(ImmutableMap.toImmutableMap(entry -> ((Subfield)entry.getKey()).tail(fieldName), Map.Entry::getValue));
                    List nestedRequiredSubfields = requiredFields.map(names -> (List)names.get(fieldName)).orElse((List)ImmutableList.of());
                    SelectiveStreamReader nestedReader = SelectiveStreamReaders.createStreamReader(nestedStream, nestedFilters, fieldOutputType, nestedRequiredSubfields, hiveStorageTimeZone, options, systemMemoryContext.newOrcAggregatedMemoryContext(), isLowMemory);
                    nestedReaders.put((Object)fieldName, (Object)nestedReader);
                    continue;
                }
                nestedReaders.put((Object)fieldName, (Object)new PruningStreamReader(nestedStream, fieldOutputType));
            }
            this.missingFieldFilterIsFalse = false;
            this.nestedReaders = nestedReaders.build();
            this.orderedNestedReaders = StructSelectiveStreamReader.orderNestedReaders(this.nestedReaders, fieldsWithFilters);
        } else {
            this.missingFieldFilterIsFalse = false;
            this.nestedReaders = ImmutableMap.of();
            this.orderedNestedReaders = new SelectiveStreamReader[0];
        }
    }

    private boolean checkMissingFieldFilters(Collection<StreamDescriptor> nestedStreams, Map<Subfield, TupleDomainFilter> filters) {
        if (filters.isEmpty()) {
            return true;
        }
        Set presentFieldNames = (Set)nestedStreams.stream().map(StreamDescriptor::getFieldName).map(name -> name.toLowerCase(Locale.ENGLISH)).collect(ImmutableSet.toImmutableSet());
        for (Map.Entry<Subfield, TupleDomainFilter> entry : filters.entrySet()) {
            String fieldName;
            Subfield subfield = entry.getKey();
            if (subfield.getPath().isEmpty() || presentFieldNames.contains(fieldName = ((Subfield.NestedField)subfield.getPath().get(0)).getName())) continue;
            TupleDomainFilter filter = entry.getValue();
            Preconditions.checkArgument((boolean)filter.isDeterministic(), (Object)"Non-deterministic range filters are not supported yet");
            if (filter.testNull()) continue;
            return false;
        }
        return true;
    }

    private static SelectiveStreamReader[] orderNestedReaders(Map<String, SelectiveStreamReader> nestedReaders, Set<String> fieldsWithFilters) {
        SelectiveStreamReader[] order = new SelectiveStreamReader[nestedReaders.size()];
        int index = 0;
        for (Map.Entry<String, SelectiveStreamReader> entry : nestedReaders.entrySet()) {
            if (!fieldsWithFilters.contains(entry.getKey())) continue;
            order[index++] = entry.getValue();
        }
        for (Map.Entry<String, SelectiveStreamReader> entry : nestedReaders.entrySet()) {
            if (fieldsWithFilters.contains(entry.getKey())) continue;
            order[index++] = entry.getValue();
        }
        return order;
    }

    @Override
    public int read(int offset, int[] positions, int positionCount) throws IOException {
        Preconditions.checkArgument((positionCount > 0 ? 1 : 0) != 0, (Object)"positionCount must be greater than zero");
        Preconditions.checkState((!this.valuesInUse ? 1 : 0) != 0, (Object)"BlockLease hasn't been closed yet");
        if (this.missingFieldFilterIsFalse) {
            this.outputPositionCount = 0;
            return 0;
        }
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        this.allNulls = false;
        this.outputPositions = SelectiveStreamReaders.initializeOutputPositions(this.outputPositions, positions, positionCount);
        this.systemMemoryContext.setBytes(this.getRetainedSizeInBytes());
        if (this.presentStream == null) {
            if (this.nonNullsAllowed) {
                if (this.nestedReaders.isEmpty()) {
                    this.outputPositionCount = positionCount;
                } else {
                    this.readNestedStreams(offset, positions, positionCount);
                    if (this.nestedOutputPositionCount > 0) {
                        this.outputPositions = SelectiveStreamReaders.initializeOutputPositions(this.outputPositions, this.nestedOutputPositions, positionCount);
                    }
                    this.outputPositionCount = this.nestedOutputPositionCount;
                }
                this.readOffset = offset + positions[positionCount - 1];
            } else {
                this.outputPositionCount = 0;
            }
        } else {
            if (this.readOffset < offset) {
                this.nestedReadOffset += this.presentStream.countBitsSet(offset - this.readOffset);
            }
            this.nulls = Arrays.ensureCapacity((boolean[])this.nulls, (int)positionCount);
            this.nestedPositions = Arrays.ensureCapacity((int[])this.nestedPositions, (int)positionCount);
            this.outputPositionCount = 0;
            int streamPosition = 0;
            int nestedPositionCount = 0;
            int nullCount = 0;
            for (int i = 0; i < positionCount; ++i) {
                int position = positions[i];
                if (position > streamPosition) {
                    int nonNullCount = this.presentStream.countBitsSet(position - streamPosition);
                    nullCount += position - streamPosition - nonNullCount;
                    streamPosition = position;
                }
                ++streamPosition;
                if (this.presentStream.nextBit()) {
                    if (!this.nonNullsAllowed) continue;
                    this.nulls[this.outputPositionCount] = false;
                    if (!this.nullsAllowed) {
                        this.outputPositions[this.outputPositionCount] = position;
                    }
                    ++this.outputPositionCount;
                    this.nestedPositions[nestedPositionCount++] = position - nullCount;
                    continue;
                }
                if (this.nullsAllowed) {
                    this.nulls[this.outputPositionCount] = true;
                    if (!this.nonNullsAllowed) {
                        this.outputPositions[this.outputPositionCount] = position;
                    }
                    ++this.outputPositionCount;
                }
                ++nullCount;
            }
            if (!this.nestedReaders.isEmpty()) {
                if (nestedPositionCount == 0) {
                    this.allNulls = true;
                } else {
                    this.readNestedStreams(this.nestedReadOffset, this.nestedPositions, nestedPositionCount);
                    this.pruneOutputPositions(nestedPositionCount);
                }
                this.nestedReadOffset += streamPosition - nullCount;
            }
            this.readOffset = offset + streamPosition;
        }
        return this.outputPositionCount;
    }

    private void pruneOutputPositions(int nestedPositionCount) {
        if (this.nestedOutputPositionCount == 0) {
            this.allNulls = true;
        }
        if (this.nestedOutputPositionCount < nestedPositionCount) {
            int nestedIndex = 0;
            int skipped = 0;
            int nestedOutputIndex = 0;
            for (int i = 0; i < this.outputPositionCount; ++i) {
                this.outputPositions[i - skipped] = this.outputPositions[i];
                if (this.nullsAllowed) {
                    this.nulls[i - skipped] = this.nulls[i];
                    if (this.nulls[i]) continue;
                }
                if (nestedOutputIndex >= this.nestedOutputPositionCount) {
                    ++skipped;
                } else if (this.nestedPositions[nestedIndex] < this.nestedOutputPositions[nestedOutputIndex]) {
                    ++skipped;
                } else {
                    ++nestedOutputIndex;
                }
                ++nestedIndex;
            }
        }
        this.outputPositionCount -= nestedPositionCount - this.nestedOutputPositionCount;
    }

    private void readNestedStreams(int offset, int[] positions, int positionCount) throws IOException {
        SelectiveStreamReader reader;
        int[] readPositions = positions;
        int readPositionCount = positionCount;
        SelectiveStreamReader[] selectiveStreamReaderArray = this.orderedNestedReaders;
        int n = selectiveStreamReaderArray.length;
        for (int i = 0; i < n && (readPositionCount = (reader = selectiveStreamReaderArray[i]).read(offset, readPositions, readPositionCount)) != 0; ++i) {
            readPositions = reader.getReadPositions();
        }
        if (readPositionCount > 0) {
            this.nestedOutputPositions = Arrays.ensureCapacity((int[])this.nestedOutputPositions, (int)positionCount);
            System.arraycopy(readPositions, 0, this.nestedOutputPositions, 0, readPositionCount);
        }
        this.nestedOutputPositionCount = readPositionCount;
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    @Override
    public int[] getReadPositions() {
        return this.outputPositions;
    }

    @Override
    public Block getBlock(int[] positions, int positionCount) {
        boolean includeNulls;
        Preconditions.checkArgument((this.outputPositionCount > 0 ? 1 : 0) != 0, (Object)"outputPositionCount must be greater than zero");
        Preconditions.checkState((boolean)this.outputRequired, (Object)"This stream reader doesn't produce output");
        Preconditions.checkState((positionCount <= this.outputPositionCount ? 1 : 0) != 0, (Object)"Not enough values");
        Preconditions.checkState((!this.valuesInUse ? 1 : 0) != 0, (Object)"BlockLease hasn't been closed yet");
        if (this.allNulls) {
            return StructSelectiveStreamReader.createNullBlock(this.outputType, positionCount);
        }
        boolean bl = includeNulls = this.nullsAllowed && this.presentStream != null;
        if (this.outputPositionCount == positionCount) {
            Block block = RowBlock.fromFieldBlocks((int)positionCount, Optional.ofNullable(includeNulls ? this.nulls : null), (Block[])this.getFieldBlocks());
            this.nulls = null;
            return block;
        }
        boolean[] nullsCopy = null;
        if (includeNulls) {
            nullsCopy = new boolean[positionCount];
        }
        int positionIndex = 0;
        int nextPosition = positions[positionIndex];
        int nestedIndex = 0;
        this.nestedOutputPositionCount = 0;
        for (int i = 0; i < this.outputPositionCount; ++i) {
            if (this.outputPositions[i] < nextPosition) {
                if (includeNulls && this.nulls[i]) continue;
                ++nestedIndex;
                continue;
            }
            assert (this.outputPositions[i] == nextPosition);
            if (!includeNulls || !this.nulls[i]) {
                this.nestedOutputPositions[this.nestedOutputPositionCount++] = this.nestedOutputPositions[nestedIndex];
                ++nestedIndex;
            }
            if (nullsCopy != null) {
                nullsCopy[positionIndex] = this.nulls[i];
            }
            if (++positionIndex >= positionCount) break;
            nextPosition = positions[positionIndex];
        }
        if (this.nestedOutputPositionCount == 0) {
            return StructSelectiveStreamReader.createNullBlock(this.outputType, positionCount);
        }
        return RowBlock.fromFieldBlocks((int)positionCount, Optional.ofNullable((boolean[])(includeNulls ? nullsCopy : null)), (Block[])this.getFieldBlocks());
    }

    private Block[] getFieldBlocks() {
        Block[] blocks = new Block[this.nestedReaders.size()];
        int i = 0;
        for (SelectiveStreamReader reader : this.nestedReaders.values()) {
            blocks[i++] = reader.getBlock(this.nestedOutputPositions, this.nestedOutputPositionCount);
        }
        return blocks;
    }

    private static RunLengthEncodedBlock createNullBlock(Type type, int positionCount) {
        return new RunLengthEncodedBlock(type.createBlockBuilder(null, 1).appendNull().build(), positionCount);
    }

    @Override
    public BlockLease getBlockView(int[] positions, int positionCount) {
        boolean includeNulls;
        Preconditions.checkArgument((this.outputPositionCount > 0 ? 1 : 0) != 0, (Object)"outputPositionCount must be greater than zero");
        Preconditions.checkState((boolean)this.outputRequired, (Object)"This stream reader doesn't produce output");
        Preconditions.checkState((positionCount <= this.outputPositionCount ? 1 : 0) != 0, (Object)"Not enough values");
        Preconditions.checkState((!this.valuesInUse ? 1 : 0) != 0, (Object)"BlockLease hasn't been closed yet");
        if (this.allNulls) {
            return this.newLease((Block)StructSelectiveStreamReader.createNullBlock(this.outputType, positionCount), new BlockLease[0]);
        }
        boolean bl = includeNulls = this.nullsAllowed && this.presentStream != null;
        if (positionCount != this.outputPositionCount) {
            this.compactValues(positions, positionCount, includeNulls);
            if (this.nestedOutputPositionCount == 0) {
                this.allNulls = true;
                return this.newLease((Block)StructSelectiveStreamReader.createNullBlock(this.outputType, positionCount), new BlockLease[0]);
            }
        }
        BlockLease[] fieldBlockLeases = new BlockLease[this.nestedReaders.size()];
        Block[] fieldBlocks = new Block[this.nestedReaders.size()];
        int i = 0;
        for (SelectiveStreamReader reader : this.nestedReaders.values()) {
            fieldBlockLeases[i] = reader.getBlockView(this.nestedOutputPositions, this.nestedOutputPositionCount);
            fieldBlocks[i] = (Block)fieldBlockLeases[i].get();
            ++i;
        }
        return this.newLease(RowBlock.fromFieldBlocks((int)positionCount, Optional.ofNullable(includeNulls ? this.nulls : null), (Block[])fieldBlocks), fieldBlockLeases);
    }

    private void compactValues(int[] positions, int positionCount, boolean compactNulls) {
        int positionIndex = 0;
        int nextPosition = positions[positionIndex];
        int nestedIndex = 0;
        this.nestedOutputPositionCount = 0;
        for (int i = 0; i < this.outputPositionCount; ++i) {
            if (this.outputPositions[i] < nextPosition) {
                if (compactNulls && this.nulls[i]) continue;
                ++nestedIndex;
                continue;
            }
            assert (this.outputPositions[i] == nextPosition);
            if (!compactNulls || !this.nulls[i]) {
                this.nestedOutputPositions[this.nestedOutputPositionCount++] = this.nestedOutputPositions[nestedIndex];
                ++nestedIndex;
            }
            if (compactNulls) {
                this.nulls[positionIndex] = this.nulls[i];
            }
            this.outputPositions[positionIndex] = nextPosition;
            if (++positionIndex >= positionCount) break;
            nextPosition = positions[positionIndex];
        }
        this.outputPositionCount = positionCount;
    }

    private BlockLease newLease(Block block, BlockLease ... fieldBlockLeases) {
        this.valuesInUse = true;
        return ClosingBlockLease.newLease((Block)block, (ClosingBlockLease.Closer[])new ClosingBlockLease.Closer[]{() -> {
            for (BlockLease lease : fieldBlockLeases) {
                lease.close();
            }
            this.valuesInUse = false;
        }});
    }

    @Override
    public void throwAnyError(int[] positions, int positionCount) {
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }

    @Override
    public void close() {
        this.nestedReaders.values().stream().forEach(StreamReader::close);
        this.outputPositions = null;
        this.nulls = null;
        this.nestedOutputPositions = null;
        this.nestedPositions = null;
        this.presentStream = null;
        this.presentStreamSource = null;
        this.systemMemoryContext.close();
    }

    @Override
    public void startStripe(Stripe stripe) throws IOException {
        this.presentStreamSource = MissingInputStreamSource.getBooleanMissingStreamSource();
        this.readOffset = 0;
        this.nestedReadOffset = 0;
        this.presentStream = null;
        this.rowGroupOpen = false;
        for (SelectiveStreamReader reader : this.nestedReaders.values()) {
            reader.startStripe(stripe);
        }
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) throws IOException {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.readOffset = 0;
        this.nestedReadOffset = 0;
        this.presentStream = null;
        this.rowGroupOpen = false;
        for (SelectiveStreamReader reader : this.nestedReaders.values()) {
            reader.startRowGroup(dataStreamSources);
        }
    }

    @Override
    public long getRetainedSizeInBytes() {
        long size = (long)INSTANCE_SIZE + SizeOf.sizeOf((int[])this.outputPositions) + SizeOf.sizeOf((int[])this.nestedPositions) + SizeOf.sizeOf((int[])this.nestedOutputPositions) + SizeOf.sizeOf((boolean[])this.nulls);
        for (SelectiveStreamReader reader : this.nestedReaders.values()) {
            size += reader.getRetainedSizeInBytes();
        }
        return size;
    }

    private static Optional<TupleDomainFilter> getTopLevelFilter(Map<Subfield, TupleDomainFilter> filters) {
        Map topLevelFilters = Maps.filterEntries(filters, entry -> ((Subfield)entry.getKey()).getPath().isEmpty());
        if (topLevelFilters.isEmpty()) {
            return Optional.empty();
        }
        Preconditions.checkArgument((topLevelFilters.size() == 1 ? 1 : 0) != 0, (Object)"ROW column may have at most one top-level range filter");
        TupleDomainFilter filter = (TupleDomainFilter)Iterables.getOnlyElement(topLevelFilters.values());
        Preconditions.checkArgument((filter == TupleDomainFilter.IS_NULL || filter == TupleDomainFilter.IS_NOT_NULL ? 1 : 0) != 0, (Object)"Top-level range filter on ROW column must be IS NULL or IS NOT NULL");
        return Optional.of(filter);
    }

    private static Optional<Map<String, List<Subfield>>> getRequiredFields(List<Subfield> requiredSubfields) {
        if (requiredSubfields.isEmpty()) {
            return Optional.empty();
        }
        HashMap<String, List> fields = new HashMap<String, List>();
        for (Subfield subfield : requiredSubfields) {
            List path = subfield.getPath();
            if (path.size() == 1 && path.get(0) instanceof Subfield.NoSubfield) continue;
            String name = ((Subfield.NestedField)path.get(0)).getName().toLowerCase(Locale.ENGLISH);
            fields.computeIfAbsent(name, k -> new ArrayList());
            if (path.size() <= 1) continue;
            ((List)fields.get(name)).add(new Subfield("c", path.subList(1, path.size())));
        }
        return Optional.of(ImmutableMap.copyOf(fields));
    }

    private static final class MissingFieldStreamReader
    implements SelectiveStreamReader {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(MissingFieldStreamReader.class).instanceSize();
        private final Type outputType;
        private int[] outputPositions;

        MissingFieldStreamReader(Type type) {
            this.outputType = Objects.requireNonNull(type, "type is required");
        }

        @Override
        public int read(int offset, int[] positions, int positionCount) {
            this.outputPositions = SelectiveStreamReaders.initializeOutputPositions(this.outputPositions, positions, positionCount);
            return positionCount;
        }

        @Override
        public int[] getReadPositions() {
            return this.outputPositions;
        }

        @Override
        public Block getBlock(int[] positions, int positionCount) {
            return StructSelectiveStreamReader.createNullBlock(this.outputType, positionCount);
        }

        @Override
        public BlockLease getBlockView(int[] positions, int positionCount) {
            return ClosingBlockLease.newLease((Block)StructSelectiveStreamReader.createNullBlock(this.outputType, positionCount), (ClosingBlockLease.Closer[])new ClosingBlockLease.Closer[0]);
        }

        @Override
        public void throwAnyError(int[] positions, int positionCount) {
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).toString();
        }

        @Override
        public void close() {
        }

        @Override
        public void startStripe(Stripe stripe) {
        }

        @Override
        public void startRowGroup(InputStreamSources dataStreamSources) {
        }

        @Override
        public long getRetainedSizeInBytes() {
            return (long)INSTANCE_SIZE + SizeOf.sizeOf((int[])this.outputPositions);
        }
    }

    private static final class PruningStreamReader
    implements SelectiveStreamReader {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(PruningStreamReader.class).instanceSize();
        private final StreamDescriptor streamDescriptor;
        @Nullable
        private final Type outputType;
        private int[] outputPositions;
        private int outputPositionCount;

        private PruningStreamReader(StreamDescriptor streamDescriptor, Optional<Type> outputType) {
            this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "streamDescriptor is null");
            this.outputType = Objects.requireNonNull(outputType, "outputType is null").orElse(null);
        }

        @Override
        public int read(int offset, int[] positions, int positionCount) {
            this.outputPositions = SelectiveStreamReaders.initializeOutputPositions(this.outputPositions, positions, positionCount);
            this.outputPositionCount = positionCount;
            return this.outputPositionCount;
        }

        @Override
        public int[] getReadPositions() {
            return this.outputPositions;
        }

        @Override
        public Block getBlock(int[] positions, int positionCount) {
            Preconditions.checkState((this.outputType != null ? 1 : 0) != 0, (Object)"This stream reader doesn't produce output");
            return StructSelectiveStreamReader.createNullBlock(this.outputType, positionCount);
        }

        @Override
        public BlockLease getBlockView(int[] positions, int positionCount) {
            Preconditions.checkState((this.outputType != null ? 1 : 0) != 0, (Object)"This stream reader doesn't produce output");
            return ClosingBlockLease.newLease((Block)StructSelectiveStreamReader.createNullBlock(this.outputType, positionCount), (ClosingBlockLease.Closer[])new ClosingBlockLease.Closer[0]);
        }

        @Override
        public void throwAnyError(int[] positions, int positionCount) {
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
        }

        @Override
        public void close() {
            this.outputPositions = null;
        }

        @Override
        public void startStripe(Stripe stripe) {
        }

        @Override
        public void startRowGroup(InputStreamSources dataStreamSources) {
        }

        @Override
        public long getRetainedSizeInBytes() {
            return (long)INSTANCE_SIZE + SizeOf.sizeOf((int[])this.outputPositions);
        }
    }
}

