/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockLease;
import com.facebook.presto.common.predicate.TupleDomainFilter;
import com.facebook.presto.common.type.Chars;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.Varchars;
import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.Stripe;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.reader.SelectiveReaderContext;
import com.facebook.presto.orc.reader.SelectiveStreamReader;
import com.facebook.presto.orc.reader.SliceDictionarySelectiveReader;
import com.facebook.presto.orc.reader.SliceDirectSelectiveStreamReader;
import com.facebook.presto.orc.stream.InputStreamSources;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.io.Closer;
import io.airlift.slice.Slice;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Optional;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class SliceSelectiveStreamReader
implements SelectiveStreamReader {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SliceSelectiveStreamReader.class).instanceSize();
    private final SelectiveReaderContext context;
    @Nullable
    private SliceDirectSelectiveStreamReader directReader;
    @Nullable
    private SliceDictionarySelectiveReader dictionaryReader;
    private SelectiveStreamReader currentReader;

    public SliceSelectiveStreamReader(StreamDescriptor streamDescriptor, Optional<TupleDomainFilter> filter, Optional<Type> outputType, OrcAggregatedMemoryContext systemMemoryContext, boolean isLowMemory, long maxSliceSize, boolean resetAllReaders) {
        this.context = new SelectiveReaderContext(streamDescriptor, outputType, filter, systemMemoryContext, isLowMemory, maxSliceSize, resetAllReaders);
    }

    public static int computeTruncatedLength(Slice slice, int offset, int length, int maxCodePointCount, boolean isCharType) {
        if (isCharType) {
            return Chars.byteCountWithoutTrailingSpace((Slice)slice, (int)offset, (int)length, (int)maxCodePointCount);
        }
        if (maxCodePointCount >= 0 && length > maxCodePointCount) {
            return Varchars.byteCount((Slice)slice, (int)offset, (int)length, (int)maxCodePointCount);
        }
        return length;
    }

    @Override
    public void startStripe(Stripe stripe) throws IOException {
        ColumnEncoding.ColumnEncodingKind kind = stripe.getColumnEncodings().get(this.context.getStreamDescriptor().getStreamId()).getColumnEncoding(this.context.getStreamDescriptor().getSequence()).getColumnEncodingKind();
        switch (kind) {
            case DIRECT: 
            case DIRECT_V2: 
            case DWRF_DIRECT: {
                if (this.directReader == null) {
                    this.directReader = new SliceDirectSelectiveStreamReader(this.context);
                }
                this.currentReader = this.directReader;
                if (this.dictionaryReader == null || !this.context.isResetAllReaders()) break;
                this.dictionaryReader = null;
                System.setProperty("RESET_SLICE_READER", "RESET_SLICE_READER");
                break;
            }
            case DICTIONARY: 
            case DICTIONARY_V2: {
                if (this.dictionaryReader == null) {
                    this.dictionaryReader = new SliceDictionarySelectiveReader(this.context);
                }
                this.currentReader = this.dictionaryReader;
                if (this.directReader == null || !this.context.isResetAllReaders()) break;
                this.directReader = null;
                System.setProperty("RESET_SLICE_READER", "RESET_SLICE_READER");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported encoding " + (Object)((Object)kind));
            }
        }
        this.currentReader.startStripe(stripe);
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) throws IOException {
        this.currentReader.startRowGroup(dataStreamSources);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.context.getStreamDescriptor()).toString();
    }

    @Override
    public void close() {
        try (Closer closer = Closer.create();){
            if (this.directReader != null) {
                closer.register(this.directReader::close);
            }
            if (this.dictionaryReader != null) {
                closer.register(this.dictionaryReader::close);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + (this.directReader == null ? 0L : this.directReader.getRetainedSizeInBytes()) + (this.dictionaryReader == null ? 0L : this.dictionaryReader.getRetainedSizeInBytes());
    }

    @Override
    public int read(int offset, int[] positions, int positionCount) throws IOException {
        return this.currentReader.read(offset, positions, positionCount);
    }

    @Override
    public int[] getReadPositions() {
        return this.currentReader.getReadPositions();
    }

    @Override
    public Block getBlock(int[] positions, int positionCount) {
        return this.currentReader.getBlock(positions, positionCount);
    }

    @Override
    public BlockLease getBlockView(int[] positions, int positionCount) {
        return this.currentReader.getBlockView(positions, positionCount);
    }

    @Override
    public void throwAnyError(int[] positions, int positionCount) {
        this.currentReader.throwAnyError(positions, positionCount);
    }

    @VisibleForTesting
    public void resetDataStream() {
        if (this.directReader != null) {
            this.directReader.resetDataStream();
        }
        if (this.dictionaryReader != null) {
            this.dictionaryReader.resetDataStream();
        }
    }
}

