/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.common.GenericInternalException;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.block.VariableWidthBlock;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.Stripe;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.reader.BatchStreamReader;
import com.facebook.presto.orc.reader.ReaderUtils;
import com.facebook.presto.orc.reader.SliceBatchStreamReader;
import com.facebook.presto.orc.stream.BooleanInputStream;
import com.facebook.presto.orc.stream.ByteArrayInputStream;
import com.facebook.presto.orc.stream.InputStreamSource;
import com.facebook.presto.orc.stream.InputStreamSources;
import com.facebook.presto.orc.stream.LongInputStream;
import com.facebook.presto.orc.stream.MissingInputStreamSource;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class SliceDirectBatchStreamReader
implements BatchStreamReader {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SliceDirectBatchStreamReader.class).instanceSize();
    private final StreamDescriptor streamDescriptor;
    private final int maxCodePointCount;
    private final boolean isCharType;
    private final long maxSliceSize;
    private int readOffset;
    private int nextBatchSize;
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.getBooleanMissingStreamSource();
    @Nullable
    private BooleanInputStream presentStream;
    private InputStreamSource<LongInputStream> lengthStreamSource = MissingInputStreamSource.getLongMissingStreamSource();
    @Nullable
    private LongInputStream lengthStream;
    private InputStreamSource<ByteArrayInputStream> dataByteSource = MissingInputStreamSource.getByteArrayMissingStreamSource();
    @Nullable
    private ByteArrayInputStream dataStream;
    private boolean rowGroupOpen;

    public SliceDirectBatchStreamReader(StreamDescriptor streamDescriptor, int maxCodePointCount, boolean isCharType, long maxSliceSize) {
        this.maxCodePointCount = maxCodePointCount;
        this.isCharType = isCharType;
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "stream is null");
        Preconditions.checkArgument((maxSliceSize < Integer.MAX_VALUE ? 1 : 0) != 0, (Object)"maxSliceSize cannot be larger than Integer.MAX_VALUE");
        Preconditions.checkArgument((maxSliceSize > 0L ? 1 : 0) != 0, (Object)"maxSliceSize must be positive");
        this.maxSliceSize = maxSliceSize;
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public Block readBlock() throws IOException {
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            if (this.readOffset > 0) {
                if (this.lengthStream == null) {
                    throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but length stream is not present");
                }
                long dataSkipSize = this.lengthStream.sum(this.readOffset);
                if (dataSkipSize > 0L) {
                    if (this.dataStream == null) {
                        throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but data stream is not present");
                    }
                    this.dataStream.skip(dataSkipSize);
                }
            }
        }
        if (this.lengthStream == null) {
            if (this.presentStream == null) {
                throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is null but present stream is missing");
            }
            this.presentStream.skip(this.nextBatchSize);
            RunLengthEncodedBlock nullValueBlock = this.readAllNullsBlock();
            this.readOffset = 0;
            this.nextBatchSize = 0;
            return nullValueBlock;
        }
        boolean[] isNullVector = null;
        int[] offsetVector = new int[this.nextBatchSize + 1];
        if (this.presentStream == null) {
            this.lengthStream.next(offsetVector, this.nextBatchSize);
        } else {
            isNullVector = new boolean[this.nextBatchSize];
            int nullCount = this.presentStream.getUnsetBits(this.nextBatchSize, isNullVector);
            if (nullCount == this.nextBatchSize) {
                RunLengthEncodedBlock nullValueBlock = this.readAllNullsBlock();
                this.readOffset = 0;
                this.nextBatchSize = 0;
                return nullValueBlock;
            }
            if (nullCount == 0) {
                isNullVector = null;
                this.lengthStream.next(offsetVector, this.nextBatchSize);
            } else {
                this.lengthStream.next(offsetVector, this.nextBatchSize - nullCount);
                ReaderUtils.unpackLengthNulls(offsetVector, isNullVector, this.nextBatchSize - nullCount);
            }
        }
        long totalLength = 0L;
        for (int i = 0; i < this.nextBatchSize; ++i) {
            totalLength += (long)offsetVector[i];
        }
        int currentBatchSize = this.nextBatchSize;
        this.readOffset = 0;
        this.nextBatchSize = 0;
        if (totalLength == 0L) {
            return new VariableWidthBlock(currentBatchSize, Slices.EMPTY_SLICE, offsetVector, Optional.ofNullable(isNullVector));
        }
        if (totalLength > this.maxSliceSize) {
            throw new GenericInternalException(String.format("Values in column \"%s\" are too large to process for Presto. Requested to read [%s] bytes, when max allowed is [%s] bytes [%s]", this.streamDescriptor.getFieldName(), totalLength, this.maxSliceSize, this.streamDescriptor.getOrcDataSourceId()));
        }
        if (this.dataStream == null) {
            throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but data stream is missing");
        }
        byte[] data = new byte[Math.toIntExact(totalLength)];
        Slice slice = Slices.wrappedBuffer((byte[])data);
        if (this.maxCodePointCount < 0) {
            this.dataStream.next(data, 0, data.length);
            ReaderUtils.convertLengthVectorToOffsetVector(offsetVector);
        } else {
            int currentLength = offsetVector[0];
            offsetVector[0] = 0;
            for (int i = 1; i <= currentBatchSize; ++i) {
                int nextLength = offsetVector[i];
                if (isNullVector != null && isNullVector[i - 1]) {
                    Preconditions.checkState((currentLength == 0 ? 1 : 0) != 0, (Object)"Corruption in slice direct stream: length is non-zero for null entry");
                    offsetVector[i] = offsetVector[i - 1];
                    currentLength = nextLength;
                    continue;
                }
                int offset = offsetVector[i - 1];
                this.dataStream.next(data, offset, offset + currentLength);
                int truncatedLength = SliceBatchStreamReader.computeTruncatedLength(slice, offset, currentLength, this.maxCodePointCount, this.isCharType);
                Verify.verify((truncatedLength >= 0 ? 1 : 0) != 0);
                offsetVector[i] = offset + truncatedLength;
                currentLength = nextLength;
            }
        }
        return new VariableWidthBlock(currentBatchSize, slice, offsetVector, Optional.ofNullable(isNullVector));
    }

    private RunLengthEncodedBlock readAllNullsBlock() {
        return new RunLengthEncodedBlock((Block)new VariableWidthBlock(1, Slices.EMPTY_SLICE, new int[2], Optional.of(new boolean[]{true})), this.nextBatchSize);
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.lengthStream = this.lengthStreamSource.openStream();
        this.dataStream = this.dataByteSource.openStream();
        this.rowGroupOpen = true;
    }

    @Override
    public void startStripe(Stripe stripe) {
        this.presentStreamSource = MissingInputStreamSource.getBooleanMissingStreamSource();
        this.lengthStreamSource = MissingInputStreamSource.getLongMissingStreamSource();
        this.dataByteSource = MissingInputStreamSource.getByteArrayMissingStreamSource();
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.lengthStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.lengthStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.LENGTH, LongInputStream.class);
        this.dataByteSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.DATA, ByteArrayInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.lengthStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }

    @Override
    public void close() {
    }

    @Override
    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE;
    }
}

