/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.DictionaryBlock;
import com.facebook.presto.common.block.VariableWidthBlock;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.OrcLocalMemoryContext;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.Stripe;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.reader.BatchStreamReader;
import com.facebook.presto.orc.reader.SliceBatchStreamReader;
import com.facebook.presto.orc.stream.BooleanInputStream;
import com.facebook.presto.orc.stream.ByteArrayInputStream;
import com.facebook.presto.orc.stream.InputStreamSource;
import com.facebook.presto.orc.stream.InputStreamSources;
import com.facebook.presto.orc.stream.LongInputStream;
import com.facebook.presto.orc.stream.MissingInputStreamSource;
import com.facebook.presto.orc.stream.RowGroupDictionaryLengthInputStream;
import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class SliceDictionaryBatchStreamReader
implements BatchStreamReader {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SliceDictionaryBatchStreamReader.class).instanceSize();
    private static final byte[] EMPTY_DICTIONARY_DATA = new byte[0];
    private static final int[] EMPTY_DICTIONARY_OFFSETS = new int[2];
    private final StreamDescriptor streamDescriptor;
    private final int maxCodePointCount;
    private final boolean isCharType;
    private int readOffset;
    private int nextBatchSize;
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.getBooleanMissingStreamSource();
    @Nullable
    private BooleanInputStream presentStream;
    private InputStreamSource<ByteArrayInputStream> stripeDictionaryDataStreamSource = MissingInputStreamSource.getByteArrayMissingStreamSource();
    private boolean stripeDictionaryOpen;
    private int stripeDictionarySize;
    private int[] stripeDictionaryLength = new int[0];
    private byte[] stripeDictionaryData = EMPTY_DICTIONARY_DATA;
    private int[] stripeDictionaryOffsetVector = EMPTY_DICTIONARY_OFFSETS;
    private VariableWidthBlock dictionaryBlock = new VariableWidthBlock(1, Slices.wrappedBuffer((byte[])EMPTY_DICTIONARY_DATA), EMPTY_DICTIONARY_OFFSETS, Optional.of(new boolean[]{true}));
    private byte[] currentDictionaryData = EMPTY_DICTIONARY_DATA;
    private InputStreamSource<LongInputStream> stripeDictionaryLengthStreamSource = MissingInputStreamSource.getLongMissingStreamSource();
    private InputStreamSource<BooleanInputStream> inDictionaryStreamSource = MissingInputStreamSource.getBooleanMissingStreamSource();
    @Nullable
    private BooleanInputStream inDictionaryStream;
    private InputStreamSource<ByteArrayInputStream> rowGroupDictionaryDataStreamSource = MissingInputStreamSource.getByteArrayMissingStreamSource();
    private InputStreamSource<RowGroupDictionaryLengthInputStream> rowGroupDictionaryLengthStreamSource = MissingInputStreamSource.getRowGroupDictionaryLengthMissingStreamSource();
    private int[] rowGroupDictionaryLength = new int[0];
    private InputStreamSource<LongInputStream> dataStreamSource = MissingInputStreamSource.getLongMissingStreamSource();
    @Nullable
    private LongInputStream dataStream;
    private boolean rowGroupOpen;
    private final OrcLocalMemoryContext systemMemoryContext;

    public SliceDictionaryBatchStreamReader(StreamDescriptor streamDescriptor, int maxCodePointCount, boolean isCharType, OrcLocalMemoryContext systemMemoryContext) {
        this.maxCodePointCount = maxCodePointCount;
        this.isCharType = isCharType;
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "stream is null");
        this.systemMemoryContext = Objects.requireNonNull(systemMemoryContext, "systemMemoryContext is null");
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public Block readBlock() throws IOException {
        int i;
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            if (this.readOffset > 0) {
                if (this.dataStream == null) {
                    throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but data stream is not present");
                }
                if (this.inDictionaryStream != null) {
                    this.inDictionaryStream.skip(this.readOffset);
                }
                this.dataStream.skip(this.readOffset);
            }
        }
        int[] idsVector = new int[this.nextBatchSize];
        if (this.presentStream == null) {
            if (this.dataStream == null) {
                throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but data stream is not present");
            }
            if (this.inDictionaryStream == null) {
                this.dataStream.next(idsVector, this.nextBatchSize);
            } else {
                for (i = 0; i < this.nextBatchSize; ++i) {
                    idsVector[i] = Math.toIntExact(this.dataStream.next());
                    if (this.inDictionaryStream.nextBit()) continue;
                    int n = i;
                    idsVector[n] = idsVector[n] + this.stripeDictionarySize;
                }
            }
        } else if (this.dataStream == null) {
            int nullValues = this.presentStream.getUnsetBits(this.nextBatchSize);
            if (nullValues != this.nextBatchSize) {
                throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but data stream is not present");
            }
        } else {
            for (i = 0; i < this.nextBatchSize; ++i) {
                if (!this.presentStream.nextBit()) {
                    idsVector[i] = this.dictionaryBlock.getPositionCount() - 1;
                    continue;
                }
                idsVector[i] = Math.toIntExact(this.dataStream.next());
                if (this.inDictionaryStream == null || this.inDictionaryStream.nextBit()) continue;
                int n = i;
                idsVector[n] = idsVector[n] + this.stripeDictionarySize;
            }
        }
        DictionaryBlock block = new DictionaryBlock(this.nextBatchSize, (Block)this.dictionaryBlock, idsVector);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return block;
    }

    private void setDictionaryBlockData(byte[] dictionaryData, int[] dictionaryOffsets, int positionCount) {
        Verify.verify((positionCount > 0 ? 1 : 0) != 0);
        if (this.currentDictionaryData != dictionaryData) {
            boolean[] isNullVector = new boolean[positionCount];
            isNullVector[positionCount - 1] = true;
            dictionaryOffsets[positionCount] = dictionaryOffsets[positionCount - 1];
            this.dictionaryBlock = new VariableWidthBlock(positionCount, Slices.wrappedBuffer((byte[])dictionaryData), dictionaryOffsets, Optional.of(isNullVector));
            this.currentDictionaryData = dictionaryData;
        }
    }

    private void openRowGroup() throws IOException {
        if (!this.stripeDictionaryOpen) {
            if (this.stripeDictionarySize > 0) {
                LongInputStream lengthStream;
                if (this.stripeDictionaryLength.length < this.stripeDictionarySize) {
                    this.stripeDictionaryLength = new int[this.stripeDictionarySize];
                    this.systemMemoryContext.setBytes(SizeOf.sizeOf((int[])this.stripeDictionaryLength));
                }
                if ((lengthStream = this.stripeDictionaryLengthStreamSource.openStream()) == null) {
                    throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Dictionary is not empty but dictionary length stream is not present");
                }
                lengthStream.next(this.stripeDictionaryLength, this.stripeDictionarySize);
                long dataLength = 0L;
                for (int i = 0; i < this.stripeDictionarySize; ++i) {
                    dataLength += (long)this.stripeDictionaryLength[i];
                }
                this.stripeDictionaryData = new byte[Math.toIntExact(dataLength)];
                this.systemMemoryContext.setBytes(SizeOf.sizeOf((byte[])this.stripeDictionaryData));
                this.stripeDictionaryOffsetVector = new int[this.stripeDictionarySize + 2];
                this.systemMemoryContext.setBytes(SizeOf.sizeOf((int[])this.stripeDictionaryOffsetVector));
                ByteArrayInputStream dictionaryDataStream = this.stripeDictionaryDataStreamSource.openStream();
                SliceDictionaryBatchStreamReader.readDictionary(dictionaryDataStream, this.stripeDictionarySize, this.stripeDictionaryLength, 0, this.stripeDictionaryData, this.stripeDictionaryOffsetVector, this.maxCodePointCount, this.isCharType);
            } else {
                this.stripeDictionaryData = EMPTY_DICTIONARY_DATA;
                this.stripeDictionaryOffsetVector = EMPTY_DICTIONARY_OFFSETS;
            }
        }
        this.stripeDictionaryOpen = true;
        RowGroupDictionaryLengthInputStream dictionaryLengthStream = this.rowGroupDictionaryLengthStreamSource.openStream();
        if (dictionaryLengthStream != null) {
            int rowGroupDictionarySize = dictionaryLengthStream.getEntryCount();
            if (this.rowGroupDictionaryLength.length < rowGroupDictionarySize) {
                this.rowGroupDictionaryLength = new int[rowGroupDictionarySize];
            }
            dictionaryLengthStream.next(this.rowGroupDictionaryLength, rowGroupDictionarySize);
            long dataLength = 0L;
            for (int i = 0; i < rowGroupDictionarySize; ++i) {
                dataLength += (long)this.rowGroupDictionaryLength[i];
            }
            byte[] rowGroupDictionaryData = Arrays.copyOf(this.stripeDictionaryData, this.stripeDictionaryOffsetVector[this.stripeDictionarySize] + Math.toIntExact(dataLength));
            int[] rowGroupDictionaryOffsetVector = Arrays.copyOf(this.stripeDictionaryOffsetVector, this.stripeDictionarySize + rowGroupDictionarySize + 2);
            ByteArrayInputStream dictionaryDataStream = this.rowGroupDictionaryDataStreamSource.openStream();
            SliceDictionaryBatchStreamReader.readDictionary(dictionaryDataStream, rowGroupDictionarySize, this.rowGroupDictionaryLength, this.stripeDictionarySize, rowGroupDictionaryData, rowGroupDictionaryOffsetVector, this.maxCodePointCount, this.isCharType);
            this.setDictionaryBlockData(rowGroupDictionaryData, rowGroupDictionaryOffsetVector, this.stripeDictionarySize + rowGroupDictionarySize + 1);
        } else {
            this.setDictionaryBlockData(this.stripeDictionaryData, this.stripeDictionaryOffsetVector, this.stripeDictionarySize + 1);
        }
        this.presentStream = this.presentStreamSource.openStream();
        this.inDictionaryStream = this.inDictionaryStreamSource.openStream();
        this.dataStream = this.dataStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    private static void readDictionary(@Nullable ByteArrayInputStream dictionaryDataStream, int dictionarySize, int[] dictionaryLengthVector, int offsetVectorOffset, byte[] data, int[] offsetVector, int maxCodePointCount, boolean isCharType) throws IOException {
        Slice slice = Slices.wrappedBuffer((byte[])data);
        if (offsetVectorOffset == 0) {
            offsetVector[0] = 0;
        }
        for (int i = 0; i < dictionarySize; ++i) {
            int truncatedLength;
            int offsetIndex = offsetVectorOffset + i;
            int offset = offsetVector[offsetIndex];
            int length = dictionaryLengthVector[i];
            if (length > 0) {
                dictionaryDataStream.next(data, offset, offset + length);
                truncatedLength = SliceBatchStreamReader.computeTruncatedLength(slice, offset, length, maxCodePointCount, isCharType);
                Verify.verify((truncatedLength >= 0 ? 1 : 0) != 0);
            } else {
                truncatedLength = 0;
            }
            offsetVector[offsetIndex + 1] = offsetVector[offsetIndex] + truncatedLength;
        }
    }

    @Override
    public void startStripe(Stripe stripe) {
        InputStreamSources dictionaryStreamSources = stripe.getDictionaryStreamSources();
        this.stripeDictionaryDataStreamSource = dictionaryStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.DICTIONARY_DATA, ByteArrayInputStream.class);
        this.stripeDictionaryLengthStreamSource = dictionaryStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.LENGTH, LongInputStream.class);
        this.stripeDictionarySize = stripe.getColumnEncodings().get(this.streamDescriptor.getStreamId()).getColumnEncoding(this.streamDescriptor.getSequence()).getDictionarySize();
        this.stripeDictionaryOpen = false;
        this.presentStreamSource = MissingInputStreamSource.getBooleanMissingStreamSource();
        this.dataStreamSource = MissingInputStreamSource.getLongMissingStreamSource();
        this.inDictionaryStreamSource = MissingInputStreamSource.getBooleanMissingStreamSource();
        this.rowGroupDictionaryLengthStreamSource = MissingInputStreamSource.getRowGroupDictionaryLengthMissingStreamSource();
        this.rowGroupDictionaryDataStreamSource = MissingInputStreamSource.getByteArrayMissingStreamSource();
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.inDictionaryStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.dataStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.DATA, LongInputStream.class);
        this.inDictionaryStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.IN_DICTIONARY, BooleanInputStream.class);
        this.rowGroupDictionaryLengthStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.ROW_GROUP_DICTIONARY_LENGTH, RowGroupDictionaryLengthInputStream.class);
        this.rowGroupDictionaryDataStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.ROW_GROUP_DICTIONARY, ByteArrayInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.inDictionaryStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }

    @Override
    public void close() {
        this.systemMemoryContext.close();
        this.stripeDictionaryLength = null;
        this.stripeDictionaryData = null;
        this.stripeDictionaryOffsetVector = null;
        this.currentDictionaryData = null;
        this.rowGroupDictionaryLength = null;
        this.dictionaryBlock = null;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((byte[])this.stripeDictionaryData) + SizeOf.sizeOf((int[])this.stripeDictionaryLength) + SizeOf.sizeOf((int[])this.stripeDictionaryOffsetVector) + SizeOf.sizeOf((int[])this.rowGroupDictionaryLength) + (this.dictionaryBlock == null ? 0L : this.dictionaryBlock.getRetainedSizeInBytes());
    }
}

