/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.common.predicate.TupleDomainFilter;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.stream.BooleanInputStream;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class SelectiveReaderContext {
    private final StreamDescriptor streamDescriptor;
    private final boolean outputRequired;
    @Nullable
    private final Type outputType;
    @Nullable
    private final TupleDomainFilter filter;
    private final boolean nonDeterministicFilter;
    private final boolean nullsAllowed;
    private final OrcAggregatedMemoryContext systemMemoryContext;
    private final boolean isLowMemory;
    private final long maxSliceSize;
    private final boolean resetAllReaders;

    public SelectiveReaderContext(StreamDescriptor streamDescriptor, Optional<Type> outputType, Optional<TupleDomainFilter> filter, OrcAggregatedMemoryContext systemMemoryContext, boolean isLowMemory, long maxSliceSize, boolean resetAllReaders) {
        this.filter = Objects.requireNonNull(filter, "filter is null").orElse(null);
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "streamDescriptor is null");
        this.outputRequired = Objects.requireNonNull(outputType, "outputType is null").isPresent();
        this.outputType = outputType.orElse(null);
        Preconditions.checkArgument((filter.isPresent() || this.outputRequired ? 1 : 0) != 0, (Object)"filter must be present if output is not required");
        this.systemMemoryContext = Objects.requireNonNull(systemMemoryContext, "systemMemoryContext is null");
        this.isLowMemory = isLowMemory;
        this.nonDeterministicFilter = this.filter != null && !this.filter.isDeterministic();
        this.nullsAllowed = this.filter == null || this.nonDeterministicFilter || this.filter.testNull();
        Preconditions.checkArgument((maxSliceSize < Integer.MAX_VALUE ? 1 : 0) != 0, (Object)"maxSliceSize cannot be larger than Integer.MAX_VALUE");
        Preconditions.checkArgument((maxSliceSize > 0L ? 1 : 0) != 0, (Object)"maxSliceSize must be positive");
        this.maxSliceSize = maxSliceSize;
        this.resetAllReaders = resetAllReaders;
    }

    public StreamDescriptor getStreamDescriptor() {
        return this.streamDescriptor;
    }

    public boolean isOutputRequired() {
        return this.outputRequired;
    }

    @Nullable
    public Type getOutputType() {
        return this.outputType;
    }

    @Nullable
    public TupleDomainFilter getFilter(BooleanInputStream presentStream) {
        if (this.isOutputRequired() && presentStream == null && this.filter == TupleDomainFilter.IS_NOT_NULL) {
            return null;
        }
        return this.filter;
    }

    public OrcAggregatedMemoryContext getSystemMemoryContext() {
        return this.systemMemoryContext;
    }

    public boolean isLowMemory() {
        return this.isLowMemory;
    }

    public boolean isNonDeterministicFilter() {
        return this.nonDeterministicFilter;
    }

    public boolean isNullsAllowed() {
        return this.nullsAllowed;
    }

    public long getMaxSliceSize() {
        return this.maxSliceSize;
    }

    public boolean isResetAllReaders() {
        return this.resetAllReaders;
    }
}

