/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockLease;
import com.facebook.presto.common.predicate.TupleDomainFilter;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.Stripe;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.reader.LongDictionarySelectiveStreamReader;
import com.facebook.presto.orc.reader.LongDirectSelectiveStreamReader;
import com.facebook.presto.orc.reader.SelectiveReaderContext;
import com.facebook.presto.orc.reader.SelectiveStreamReader;
import com.facebook.presto.orc.stream.InputStreamSources;
import com.google.common.base.MoreObjects;
import com.google.common.io.Closer;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Optional;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class LongSelectiveStreamReader
implements SelectiveStreamReader {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(LongSelectiveStreamReader.class).instanceSize();
    private final SelectiveReaderContext context;
    @Nullable
    private LongDirectSelectiveStreamReader directReader;
    @Nullable
    private LongDictionarySelectiveStreamReader dictionaryReader;
    private SelectiveStreamReader currentReader;

    public LongSelectiveStreamReader(StreamDescriptor streamDescriptor, Optional<TupleDomainFilter> filter, Optional<Type> outputType, OrcAggregatedMemoryContext systemMemoryContext, boolean isLowMemory, long maxSliceSize, boolean resetAllReaders) {
        this.context = new SelectiveReaderContext(streamDescriptor, outputType, filter, systemMemoryContext, isLowMemory, maxSliceSize, resetAllReaders);
    }

    @Override
    public void startStripe(Stripe stripe) throws IOException {
        StreamDescriptor streamDescriptor = this.context.getStreamDescriptor();
        ColumnEncoding.ColumnEncodingKind kind = stripe.getColumnEncodings().get(streamDescriptor.getStreamId()).getColumnEncoding(streamDescriptor.getSequence()).getColumnEncodingKind();
        switch (kind) {
            case DIRECT: 
            case DIRECT_V2: 
            case DWRF_DIRECT: {
                if (this.directReader == null) {
                    this.directReader = new LongDirectSelectiveStreamReader(this.context);
                }
                this.currentReader = this.directReader;
                if (this.dictionaryReader == null || !this.context.isResetAllReaders()) break;
                this.dictionaryReader = null;
                System.setProperty("RESET_LONG_READER", "RESET_LONG_READER");
                break;
            }
            case DICTIONARY: {
                if (this.dictionaryReader == null) {
                    this.dictionaryReader = new LongDictionarySelectiveStreamReader(this.context);
                }
                this.currentReader = this.dictionaryReader;
                if (this.directReader == null || !this.context.isResetAllReaders()) break;
                this.directReader = null;
                System.setProperty("RESET_LONG_READER", "RESET_LONG_READER");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported encoding " + (Object)((Object)kind));
            }
        }
        this.currentReader.startStripe(stripe);
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) throws IOException {
        this.currentReader.startRowGroup(dataStreamSources);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.context.getStreamDescriptor()).toString();
    }

    @Override
    public void close() {
        try (Closer closer = Closer.create();){
            if (this.directReader != null) {
                closer.register(this.directReader::close);
            }
            if (this.dictionaryReader != null) {
                closer.register(this.dictionaryReader::close);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + (this.directReader == null ? 0L : this.directReader.getRetainedSizeInBytes()) + (this.dictionaryReader == null ? 0L : this.dictionaryReader.getRetainedSizeInBytes());
    }

    @Override
    public int read(int offset, int[] positions, int positionCount) throws IOException {
        return this.currentReader.read(offset, positions, positionCount);
    }

    @Override
    public int[] getReadPositions() {
        return this.currentReader.getReadPositions();
    }

    @Override
    public Block getBlock(int[] positions, int positionCount) {
        return this.currentReader.getBlock(positions, positionCount);
    }

    @Override
    public BlockLease getBlockView(int[] positions, int positionCount) {
        return this.currentReader.getBlockView(positions, positionCount);
    }

    @Override
    public void throwAnyError(int[] positions, int positionCount) {
        this.currentReader.throwAnyError(positions, positionCount);
    }
}

