/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.stream.InputStreamSource;
import com.facebook.presto.orc.stream.InputStreamSources;
import com.facebook.presto.orc.stream.LongInputStream;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class LongDictionaryProvider {
    private final InputStreamSources dictionaryStreamSources;
    private final Map<Integer, SharedDictionary> sharedDictionaries;

    public LongDictionaryProvider(InputStreamSources dictionaryStreamSources) {
        this.dictionaryStreamSources = Objects.requireNonNull(dictionaryStreamSources, "dictionaryStreamSources is null");
        this.sharedDictionaries = new HashMap<Integer, SharedDictionary>();
    }

    public DictionaryResult getDictionary(StreamDescriptor streamDescriptor, long[] dictionary, int items) throws IOException {
        boolean isNewEntry;
        InputStreamSource<LongInputStream> dictionaryDataStream = this.dictionaryStreamSources.getInputStreamSource(streamDescriptor, Stream.StreamKind.DICTIONARY_DATA, LongInputStream.class);
        if (dictionaryDataStream.openStream() != null) {
            return this.loadDictionary(streamDescriptor, dictionaryDataStream, dictionary, items);
        }
        int streamId = streamDescriptor.getStreamId();
        SharedDictionary sharedDictionary = this.sharedDictionaries.get(streamId);
        boolean bl = isNewEntry = sharedDictionary == null;
        if (isNewEntry) {
            StreamDescriptor sharedDictionaryStreamDescriptor = streamDescriptor.duplicate(0);
            InputStreamSource<LongInputStream> sharedDictionaryDataStream = this.dictionaryStreamSources.getInputStreamSource(sharedDictionaryStreamDescriptor, Stream.StreamKind.DICTIONARY_DATA, LongInputStream.class);
            long[] dictionaryBuffer = this.loadDictionary(streamDescriptor, sharedDictionaryDataStream, dictionary, items).dictionaryBuffer();
            sharedDictionary = new SharedDictionary(dictionaryBuffer, items);
            this.sharedDictionaries.put(streamId, sharedDictionary);
        }
        Preconditions.checkState((sharedDictionary.size == items ? 1 : 0) != 0, (String)"Shared dictionary size mismatch for stream: %s", (Object)streamDescriptor);
        return new DictionaryResult(sharedDictionary.values, isNewEntry);
    }

    private DictionaryResult loadDictionary(StreamDescriptor streamDescriptor, InputStreamSource<LongInputStream> dictionaryDataStream, long[] dictionaryBuffer, int items) throws IOException {
        LongInputStream inputStream = dictionaryDataStream.openStream();
        if (inputStream == null) {
            throw new OrcCorruptionException(streamDescriptor.getOrcDataSourceId(), "Dictionary is not empty but data stream is not present for %s", streamDescriptor);
        }
        if (dictionaryBuffer == null || dictionaryBuffer.length < items) {
            dictionaryBuffer = new long[items];
        }
        inputStream.next(dictionaryBuffer, items);
        return new DictionaryResult(dictionaryBuffer, true);
    }

    public static class DictionaryResult {
        private final long[] dictionaryBuffer;
        private final boolean isBufferOwner;

        DictionaryResult(long[] dictionaryBuffer, boolean isBufferOwner) {
            this.dictionaryBuffer = Objects.requireNonNull(dictionaryBuffer);
            this.isBufferOwner = isBufferOwner;
        }

        public long[] dictionaryBuffer() {
            return this.dictionaryBuffer;
        }

        public boolean isBufferOwner() {
            return this.isBufferOwner;
        }
    }

    private static class SharedDictionary {
        private final long[] values;
        private final int size;

        SharedDictionary(long[] values, int size) {
            this.values = Objects.requireNonNull(values);
            this.size = size;
        }
    }
}

