/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.DecimalColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.DecimalStatistics;
import com.facebook.presto.orc.metadata.statistics.StatisticsBuilder;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class LongDecimalStatisticsBuilder
implements StatisticsBuilder {
    public static final long LONG_DECIMAL_VALUE_BYTES = 16L;
    private long nonNullValueCount;
    private long storageSize;
    private long rawSize;
    private BigDecimal minimum;
    private BigDecimal maximum;

    @Override
    public void addBlock(Type type, Block block) {
        int scale = ((DecimalType)type).getScale();
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (block.isNull(position)) continue;
            Slice value = type.getSlice(block, position);
            this.addValue(new BigDecimal(Decimals.decodeUnscaledValue((Slice)value), scale));
        }
    }

    public void addValue(BigDecimal value) {
        Objects.requireNonNull(value, "value is null");
        ++this.nonNullValueCount;
        if (this.minimum == null) {
            this.minimum = value;
            this.maximum = value;
        } else {
            this.minimum = this.minimum.min(value);
            this.maximum = this.maximum.max(value);
        }
    }

    private void addDecimalStatistics(long valueCount, DecimalStatistics value) {
        Objects.requireNonNull(value, "value is null");
        Objects.requireNonNull(value.getMin(), "value.getMin() is null");
        Objects.requireNonNull(value.getMax(), "value.getMax() is null");
        this.nonNullValueCount += valueCount;
        if (this.minimum == null) {
            this.minimum = value.getMin();
            this.maximum = value.getMax();
        } else {
            this.minimum = this.minimum.min(value.getMin());
            this.maximum = this.maximum.max(value.getMax());
        }
    }

    private Optional<DecimalStatistics> buildDecimalStatistics(long decimalSizeInBytes) {
        if (this.nonNullValueCount == 0L) {
            return Optional.empty();
        }
        Preconditions.checkState((this.minimum != null && this.maximum != null ? 1 : 0) != 0);
        return Optional.of(new DecimalStatistics(this.minimum, this.maximum, decimalSizeInBytes));
    }

    @Override
    public ColumnStatistics buildColumnStatistics() {
        Optional<DecimalStatistics> decimalStatistics = this.buildDecimalStatistics(16L);
        if (decimalStatistics.isPresent()) {
            return new DecimalColumnStatistics(this.nonNullValueCount, null, this.rawSize, this.storageSize, decimalStatistics.get());
        }
        return new ColumnStatistics(this.nonNullValueCount, null, this.rawSize, this.storageSize);
    }

    @Override
    public void incrementRawSize(long rawSize) {
        this.rawSize += rawSize;
    }

    @Override
    public void incrementSize(long storageSize) {
        this.storageSize += storageSize;
    }

    public static Optional<DecimalStatistics> mergeDecimalStatistics(List<ColumnStatistics> stats) {
        LongDecimalStatisticsBuilder decimalStatisticsBuilder = new LongDecimalStatisticsBuilder();
        long decimalSizeInBytes = 0L;
        for (ColumnStatistics columnStatistics : stats) {
            DecimalStatistics partialStatistics = columnStatistics.getDecimalStatistics();
            if (columnStatistics.getNumberOfValues() <= 0L) continue;
            if (partialStatistics == null) {
                return Optional.empty();
            }
            decimalStatisticsBuilder.addDecimalStatistics(columnStatistics.getNumberOfValues(), partialStatistics);
            decimalSizeInBytes = Math.max(decimalSizeInBytes, partialStatistics.getDecimalSizeInBytes());
        }
        return decimalStatisticsBuilder.buildDecimalStatistics(decimalSizeInBytes);
    }
}

