/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.orc.metadata.statistics.RangeStatistics;
import com.facebook.presto.orc.metadata.statistics.StatisticsHasher;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class IntegerStatistics
implements RangeStatistics<Long>,
StatisticsHasher.Hashable {
    public static final long INTEGER_VALUE_BYTES = 9L;
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(IntegerStatistics.class).instanceSize();
    private final boolean hasMinimum;
    private final boolean hasMaximum;
    private final boolean hasSum;
    private final long minimum;
    private final long maximum;
    private final long sum;

    public IntegerStatistics(Long minimum, Long maximum, Long sum) {
        Preconditions.checkArgument((minimum == null || maximum == null || minimum <= maximum ? 1 : 0) != 0, (Object)"minimum is not less than maximum");
        this.hasMinimum = minimum != null;
        this.minimum = this.hasMinimum ? minimum : 0L;
        this.hasMaximum = maximum != null;
        this.maximum = this.hasMaximum ? maximum : 0L;
        this.hasSum = sum != null;
        this.sum = this.hasSum ? sum : 0L;
    }

    @Override
    public Long getMin() {
        return this.hasMinimum ? Long.valueOf(this.minimum) : null;
    }

    public long getMinPrimitive() {
        Preconditions.checkState((boolean)this.hasMinimum, (Object)"minimum value is missing");
        return this.minimum;
    }

    @Override
    public Long getMax() {
        return this.hasMaximum ? Long.valueOf(this.maximum) : null;
    }

    public long getMaxPrimitive() {
        Preconditions.checkState((boolean)this.hasMaximum, (Object)"maximum value is missing");
        return this.maximum;
    }

    public Long getSum() {
        return this.hasSum ? Long.valueOf(this.sum) : null;
    }

    public boolean hasSum() {
        return this.hasSum;
    }

    public long getSumPrimitive() {
        Preconditions.checkState((boolean)this.hasSum);
        return this.sum;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntegerStatistics that = (IntegerStatistics)o;
        return Objects.equals(this.getMin(), that.getMin()) && Objects.equals(this.getMax(), that.getMax()) && Objects.equals(this.getSum(), that.getSum());
    }

    public int hashCode() {
        return Objects.hash(this.getMin(), this.getMax(), this.getSum());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("min", (Object)this.getMin()).add("max", (Object)this.getMax()).add("sum", (Object)this.getSum()).toString();
    }

    @Override
    public void addHash(StatisticsHasher hasher) {
        hasher.putOptionalLong(this.hasMinimum, this.minimum).putOptionalLong(this.hasMaximum, this.maximum).putOptionalLong(this.hasSum, this.sum);
    }
}

