/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.StatisticsBuilder;

public class CountStatisticsBuilder
implements StatisticsBuilder {
    private long nonNullValueCount;
    private long storageSize;
    private long rawSize;

    @Override
    public void addBlock(Type type, Block block) {
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (block.isNull(position)) continue;
            ++this.nonNullValueCount;
        }
    }

    @Override
    public void addValue(Type type, Block block, int position) {
        if (!block.isNull(position)) {
            ++this.nonNullValueCount;
        }
    }

    public void addValue() {
        ++this.nonNullValueCount;
    }

    @Override
    public ColumnStatistics buildColumnStatistics() {
        return new ColumnStatistics(this.nonNullValueCount, null, this.rawSize, this.storageSize);
    }

    @Override
    public void incrementRawSize(long rawSize) {
        this.rawSize += rawSize;
    }

    @Override
    public void incrementSize(long storageSize) {
        this.storageSize += storageSize;
    }
}

