/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;

public class BloomFilter {
    protected BitSet bitSet;
    protected int numBits;
    protected int numHashFunctions;

    public BloomFilter() {
    }

    static void checkArgument(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public BloomFilter(long expectedEntries, double fpp) {
        BloomFilter.checkArgument(expectedEntries > 0L, "expectedEntries should be > 0");
        BloomFilter.checkArgument(fpp > 0.0 && fpp < 1.0, "False positive probability should be > 0.0 & < 1.0");
        int nb = BloomFilter.optimalNumOfBits(expectedEntries, fpp);
        this.numBits = nb + (64 - nb % 64);
        this.numHashFunctions = BloomFilter.optimalNumOfHashFunctions(expectedEntries, this.numBits);
        this.bitSet = new BitSet(this.numBits);
    }

    static int optimalNumOfHashFunctions(long n, long m) {
        return Math.max(1, (int)Math.round((double)m / (double)n * Math.log(2.0)));
    }

    static int optimalNumOfBits(long n, double p) {
        return (int)((double)(-n) * Math.log(p) / (Math.log(2.0) * Math.log(2.0)));
    }

    public void add(byte[] val) {
        if (val == null) {
            this.addBytes(val, -1, -1);
        } else {
            this.addBytes(val, 0, val.length);
        }
    }

    public void addBytes(byte[] val, int offset, int length) {
        long hash64 = val == null ? 2862933555777941757L : Murmur3.hash64(val, offset, length);
        this.addHash(hash64);
    }

    private void addHash(long hash64) {
        int hash1 = (int)hash64;
        int hash2 = (int)(hash64 >>> 32);
        for (int i = 1; i <= this.numHashFunctions; ++i) {
            int combinedHash = hash1 + i * hash2;
            if (combinedHash < 0) {
                combinedHash ^= 0xFFFFFFFF;
            }
            int pos = combinedHash % this.numBits;
            this.bitSet.set(pos);
        }
    }

    public void addString(String val) {
        if (val == null) {
            this.add(null);
        } else {
            this.add(val.getBytes());
        }
    }

    public void addLong(long val) {
        this.addHash(this.getLongHash(val));
    }

    public void addDouble(double val) {
        this.addLong(Double.doubleToLongBits(val));
    }

    public boolean test(byte[] val) {
        return val == null ? this.testBytes(val, -1, -1) : this.testBytes(val, 0, val.length);
    }

    public boolean testBytes(byte[] val, int offset, int length) {
        long hash64 = val == null ? 2862933555777941757L : Murmur3.hash64(val, offset, length);
        return this.testHash(hash64);
    }

    private boolean testHash(long hash64) {
        int hash1 = (int)hash64;
        int hash2 = (int)(hash64 >>> 32);
        for (int i = 1; i <= this.numHashFunctions; ++i) {
            int pos;
            int combinedHash = hash1 + i * hash2;
            if (combinedHash < 0) {
                combinedHash ^= 0xFFFFFFFF;
            }
            if (this.bitSet.get(pos = combinedHash % this.numBits)) continue;
            return false;
        }
        return true;
    }

    public boolean testString(String val) {
        return val == null ? this.test(null) : this.test(val.getBytes());
    }

    public boolean testLong(long val) {
        return this.testHash(this.getLongHash(val));
    }

    private long getLongHash(long key) {
        key = (key ^ 0xFFFFFFFFFFFFFFFFL) + (key << 21);
        key ^= key >> 24;
        key = key + (key << 3) + (key << 8);
        key ^= key >> 14;
        key = key + (key << 2) + (key << 4);
        key ^= key >> 28;
        key += key << 31;
        return key;
    }

    public boolean testDouble(double val) {
        return this.testLong(Double.doubleToLongBits(val));
    }

    public long sizeInBytes() {
        return this.getBitSize() / 8;
    }

    public int getBitSize() {
        return this.bitSet.getData().length * 64;
    }

    public int getNumHashFunctions() {
        return this.numHashFunctions;
    }

    public long[] getBitSet() {
        return this.bitSet.getData();
    }

    public String toString() {
        return "m: " + this.numBits + " k: " + this.numHashFunctions;
    }

    public void merge(BloomFilter that) {
        if (this == that || this.numBits != that.numBits || this.numHashFunctions != that.numHashFunctions) {
            throw new IllegalArgumentException("BloomFilters are not compatible for merging. this - " + this.toString() + " that - " + that.toString());
        }
        this.bitSet.putAll(that.bitSet);
    }

    public void reset() {
        this.bitSet.clear();
    }

    public static class BitSet {
        private final long[] data;

        public BitSet(long bits) {
            this(new long[(int)Math.ceil((double)bits / 64.0)]);
        }

        public BitSet(long[] data) {
            assert (data.length > 0) : "data length is zero!";
            this.data = data;
        }

        public void set(int index) {
            long[] var10000 = this.data;
            int n = index >>> 6;
            var10000[n] = var10000[n] | 1L << index;
        }

        public boolean get(int index) {
            return (this.data[index >>> 6] & 1L << index) != 0L;
        }

        public long bitSize() {
            return (long)this.data.length * 64L;
        }

        public long[] getData() {
            return this.data;
        }

        public void putAll(BitSet array) {
            assert (this.data.length == array.data.length) : "BitArrays must be of equal length (" + this.data.length + "!= " + array.data.length + ")";
            for (int i = 0; i < this.data.length; ++i) {
                long[] var10000 = this.data;
                int n = i;
                var10000[n] = var10000[n] | array.data[i];
            }
        }

        public void clear() {
            Arrays.fill(this.data, 0L);
        }
    }

    public static class Murmur3 {
        public static final long NULL_HASHCODE = 2862933555777941757L;
        private static final long C1 = -8663945395140668459L;
        private static final long C2 = 5545529020109919103L;
        private static final int R1 = 31;
        private static final int R2 = 27;
        private static final int M = 5;
        private static final int N1 = 1390208809;
        public static final int DEFAULT_SEED = 104729;

        @VisibleForTesting
        static long hash64(byte[] data) {
            return Murmur3.hash64(data, 0, data.length);
        }

        public static long hash64(byte[] data, int offset, int length) {
            return Murmur3.hash64(data, offset, length, 104729);
        }

        public static long hash64(byte[] data, int offset, int length, int seed) {
            long hash = seed;
            int nblocks = length >> 3;
            for (int i = 0; i < nblocks; ++i) {
                int i8 = i << 3;
                long k = (long)data[offset + i8] & 0xFFL | ((long)data[offset + i8 + 1] & 0xFFL) << 8 | ((long)data[offset + i8 + 2] & 0xFFL) << 16 | ((long)data[offset + i8 + 3] & 0xFFL) << 24 | ((long)data[offset + i8 + 4] & 0xFFL) << 32 | ((long)data[offset + i8 + 5] & 0xFFL) << 40 | ((long)data[offset + i8 + 6] & 0xFFL) << 48 | ((long)data[offset + i8 + 7] & 0xFFL) << 56;
                k *= -8663945395140668459L;
                k = Long.rotateLeft(k, 31);
                hash ^= (k *= 5545529020109919103L);
                hash = Long.rotateLeft(hash, 27) * 5L + 1390208809L;
            }
            long k1 = 0L;
            int tailStart = nblocks << 3;
            switch (length - tailStart) {
                case 7: {
                    k1 ^= ((long)data[offset + tailStart + 6] & 0xFFL) << 48;
                }
                case 6: {
                    k1 ^= ((long)data[offset + tailStart + 5] & 0xFFL) << 40;
                }
                case 5: {
                    k1 ^= ((long)data[offset + tailStart + 4] & 0xFFL) << 32;
                }
                case 4: {
                    k1 ^= ((long)data[offset + tailStart + 3] & 0xFFL) << 24;
                }
                case 3: {
                    k1 ^= ((long)data[offset + tailStart + 2] & 0xFFL) << 16;
                }
                case 2: {
                    k1 ^= ((long)data[offset + tailStart + 1] & 0xFFL) << 8;
                }
                case 1: {
                    k1 ^= (long)data[offset + tailStart] & 0xFFL;
                    k1 *= -8663945395140668459L;
                    k1 = Long.rotateLeft(k1, 31);
                    hash ^= (k1 *= 5545529020109919103L);
                }
            }
            hash ^= (long)length;
            hash = Murmur3.fmix64(hash);
            return hash;
        }

        private static long fmix64(long h) {
            h ^= h >>> 33;
            h *= -49064778989728563L;
            h ^= h >>> 33;
            h *= -4265267296055464877L;
            h ^= h >>> 33;
            return h;
        }
    }
}

