/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.orc.metadata.statistics.StatisticsHasher;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class BinaryStatistics
implements StatisticsHasher.Hashable {
    public static final long BINARY_VALUE_BYTES_OVERHEAD = 5L;
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(BinaryStatistics.class).instanceSize();
    private final long sum;

    public BinaryStatistics(long sum) {
        this.sum = sum;
    }

    public long getSum() {
        return this.sum;
    }

    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sum", this.sum).toString();
    }

    @Override
    public void addHash(StatisticsHasher hasher) {
        hasher.putLong(this.sum);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinaryStatistics that = (BinaryStatistics)o;
        return this.sum == that.sum;
    }

    public int hashCode() {
        return Objects.hash(this.sum);
    }
}

