/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata;

import com.facebook.presto.orc.DwrfEncryptionProvider;
import com.facebook.presto.orc.DwrfKeyProvider;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcDataSourceId;
import com.facebook.presto.orc.OrcDecompressor;
import com.facebook.presto.orc.metadata.Footer;
import com.facebook.presto.orc.metadata.Metadata;
import com.facebook.presto.orc.metadata.MetadataReader;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.metadata.PostScript;
import com.facebook.presto.orc.metadata.RowGroupIndex;
import com.facebook.presto.orc.metadata.StripeFooter;
import com.facebook.presto.orc.metadata.statistics.HiveBloomFilter;
import com.facebook.presto.orc.protobuf.InvalidProtocolBufferException;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ExceptionWrappingMetadataReader
implements MetadataReader {
    private final OrcDataSourceId orcDataSourceId;
    private final MetadataReader delegate;

    public ExceptionWrappingMetadataReader(OrcDataSourceId orcDataSourceId, MetadataReader delegate) {
        this.orcDataSourceId = Objects.requireNonNull(orcDataSourceId, "orcDataSourceId is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        Preconditions.checkArgument((!(delegate instanceof ExceptionWrappingMetadataReader) ? 1 : 0) != 0, (Object)"ExceptionWrappingMetadataReader can not wrap a ExceptionWrappingMetadataReader");
    }

    @Override
    public PostScript readPostScript(byte[] data, int offset, int length) throws OrcCorruptionException, IOException {
        try {
            return this.delegate.readPostScript(data, offset, length);
        }
        catch (InvalidProtocolBufferException e) {
            throw new OrcCorruptionException(e, this.orcDataSourceId, "Invalid postscript", new Object[0]);
        }
    }

    @Override
    public Metadata readMetadata(PostScript.HiveWriterVersion hiveWriterVersion, InputStream inputStream) throws OrcCorruptionException, IOException {
        try {
            return this.delegate.readMetadata(hiveWriterVersion, inputStream);
        }
        catch (InvalidProtocolBufferException e) {
            throw new OrcCorruptionException(e, this.orcDataSourceId, "Invalid file metadata", new Object[0]);
        }
    }

    @Override
    public Footer readFooter(PostScript.HiveWriterVersion hiveWriterVersion, InputStream inputStream, DwrfEncryptionProvider dwrfEncryptionProvider, DwrfKeyProvider dwrfKeyProvider, OrcDataSource orcDataSource, Optional<OrcDecompressor> decompressor) throws OrcCorruptionException, IOException {
        try {
            return this.delegate.readFooter(hiveWriterVersion, inputStream, dwrfEncryptionProvider, dwrfKeyProvider, orcDataSource, decompressor);
        }
        catch (InvalidProtocolBufferException e) {
            throw new OrcCorruptionException(e, this.orcDataSourceId, "Invalid file footer", new Object[0]);
        }
    }

    @Override
    public StripeFooter readStripeFooter(OrcDataSourceId orcDataSourceId, List<OrcType> types, InputStream inputStream) throws IOException {
        try {
            return this.delegate.readStripeFooter(orcDataSourceId, types, inputStream);
        }
        catch (InvalidProtocolBufferException e) {
            throw new OrcCorruptionException(e, orcDataSourceId, "Invalid stripe footer", new Object[0]);
        }
    }

    @Override
    public List<RowGroupIndex> readRowIndexes(PostScript.HiveWriterVersion hiveWriterVersion, InputStream inputStream, List<HiveBloomFilter> bloomFilters) throws OrcCorruptionException, IOException {
        try {
            return this.delegate.readRowIndexes(hiveWriterVersion, inputStream, bloomFilters);
        }
        catch (InvalidProtocolBufferException e) {
            throw new OrcCorruptionException(e, this.orcDataSourceId, "Invalid stripe row index", new Object[0]);
        }
    }

    @Override
    public List<HiveBloomFilter> readBloomFilterIndexes(InputStream inputStream) throws OrcCorruptionException, IOException {
        try {
            return this.delegate.readBloomFilterIndexes(inputStream);
        }
        catch (InvalidProtocolBufferException e) {
            throw new OrcCorruptionException(e, this.orcDataSourceId, "Invalid bloom filter", new Object[0]);
        }
    }
}

