/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.cache;

import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcDataSourceId;
import com.facebook.presto.orc.OrcWriteValidation;
import com.facebook.presto.orc.cache.OrcFileTailSource;
import com.facebook.presto.orc.metadata.MetadataReader;
import com.facebook.presto.orc.metadata.OrcFileTail;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;

public class CachingOrcFileTailSource
implements OrcFileTailSource {
    private final Cache<OrcDataSourceId, OrcFileTail> cache;
    private final OrcFileTailSource delegate;

    public CachingOrcFileTailSource(OrcFileTailSource delegate, Cache<OrcDataSourceId, OrcFileTail> cache) {
        this.cache = Objects.requireNonNull(cache, "cache is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    @Override
    public OrcFileTail getOrcFileTail(OrcDataSource orcDataSource, MetadataReader metadataReader, Optional<OrcWriteValidation> writeValidation, boolean cacheable, long fileModificationTime) throws IOException {
        if (!cacheable) {
            return this.delegate.getOrcFileTail(orcDataSource, metadataReader, writeValidation, cacheable, fileModificationTime);
        }
        try {
            OrcFileTail orcFileTail = (OrcFileTail)this.cache.getIfPresent((Object)orcDataSource.getId());
            if (orcFileTail != null) {
                if (orcFileTail.getFileModificationTime() == fileModificationTime) {
                    return orcFileTail;
                }
                this.cache.invalidate((Object)orcDataSource.getId());
                this.cache.getIfPresent((Object)orcDataSource.getId());
            }
            orcFileTail = this.delegate.getOrcFileTail(orcDataSource, metadataReader, writeValidation, cacheable, fileModificationTime);
            this.cache.put((Object)orcDataSource.getId(), (Object)orcFileTail);
            return orcFileTail;
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), IOException.class);
            throw new IOException("Unexpected error in orc file tail reading after cache miss", e.getCause());
        }
    }
}

